package zio.aws.migrationhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.migrationhub.model.primitives.{UpdateDateTime, ApplicationId}
import scala.jdk.CollectionConverters._
final case class ApplicationState(
    applicationId: Option[ApplicationId] = None,
    applicationStatus: Option[zio.aws.migrationhub.model.ApplicationStatus] =
      None,
    lastUpdatedTime: Option[UpdateDateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.ApplicationState = {
    import ApplicationState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.ApplicationState
      .builder()
      .optionallyWith(
        applicationId.map(value =>
          ApplicationId.unwrap(value): java.lang.String
        )
      )(_.applicationId)
      .optionallyWith(applicationStatus.map(value => value.unwrap))(
        _.applicationStatus
      )
      .optionallyWith(
        lastUpdatedTime.map(value => UpdateDateTime.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .build()
  }
  def asReadOnly: zio.aws.migrationhub.model.ApplicationState.ReadOnly =
    zio.aws.migrationhub.model.ApplicationState.wrap(buildAwsValue())
}
object ApplicationState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.ApplicationState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhub.model.ApplicationState =
      zio.aws.migrationhub.model.ApplicationState(
        applicationId.map(value => value),
        applicationStatus.map(value => value),
        lastUpdatedTime.map(value => value)
      )
    def applicationId: Option[ApplicationId]
    def applicationStatus: Option[zio.aws.migrationhub.model.ApplicationStatus]
    def lastUpdatedTime: Option[UpdateDateTime]
    def getApplicationId: ZIO[Any, AwsError, ApplicationId] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getApplicationStatus
        : ZIO[Any, AwsError, zio.aws.migrationhub.model.ApplicationStatus] =
      AwsError.unwrapOptionField("applicationStatus", applicationStatus)
    def getLastUpdatedTime: ZIO[Any, AwsError, UpdateDateTime] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.ApplicationState
  ) extends zio.aws.migrationhub.model.ApplicationState.ReadOnly {
    override val applicationId: Option[ApplicationId] = scala
      .Option(impl.applicationId())
      .map(value => zio.aws.migrationhub.model.primitives.ApplicationId(value))
    override val applicationStatus
        : Option[zio.aws.migrationhub.model.ApplicationStatus] = scala
      .Option(impl.applicationStatus())
      .map(value => zio.aws.migrationhub.model.ApplicationStatus.wrap(value))
    override val lastUpdatedTime: Option[UpdateDateTime] = scala
      .Option(impl.lastUpdatedTime())
      .map(value => zio.aws.migrationhub.model.primitives.UpdateDateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.ApplicationState
  ): zio.aws.migrationhub.model.ApplicationState.ReadOnly = new Wrapper(impl)
}
