package zio.aws.migrationhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhub.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class ListDiscoveredResourcesResponse(
    nextToken: Option[Token] = None,
    discoveredResourceList: Option[
      Iterable[zio.aws.migrationhub.model.DiscoveredResource]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesResponse = {
    import ListDiscoveredResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        discoveredResourceList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.discoveredResourceList)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhub.model.ListDiscoveredResourcesResponse.ReadOnly =
    zio.aws.migrationhub.model.ListDiscoveredResourcesResponse
      .wrap(buildAwsValue())
}
object ListDiscoveredResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhub.model.ListDiscoveredResourcesResponse =
      zio.aws.migrationhub.model.ListDiscoveredResourcesResponse(
        nextToken.map(value => value),
        discoveredResourceList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[Token]
    def discoveredResourceList
        : Option[List[zio.aws.migrationhub.model.DiscoveredResource.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getDiscoveredResourceList: ZIO[Any, AwsError, List[
      zio.aws.migrationhub.model.DiscoveredResource.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "discoveredResourceList",
      discoveredResourceList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesResponse
  ) extends zio.aws.migrationhub.model.ListDiscoveredResourcesResponse.ReadOnly {
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.migrationhub.model.primitives.Token(value))
    override val discoveredResourceList
        : Option[List[zio.aws.migrationhub.model.DiscoveredResource.ReadOnly]] =
      scala
        .Option(impl.discoveredResourceList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhub.model.DiscoveredResource.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesResponse
  ): zio.aws.migrationhub.model.ListDiscoveredResourcesResponse.ReadOnly =
    new Wrapper(impl)
}
