package zio.aws.migrationhub.model
import scala.jdk.CollectionConverters._
sealed trait ResourceAttributeType {
  def unwrap
      : software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType
}
object ResourceAttributeType {
  def wrap(
      value: software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType
  ): zio.aws.migrationhub.model.ResourceAttributeType = value match {
    case software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType.IPV4_ADDRESS =>
      val r = IPV4_ADDRESS
      r
    case software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType.IPV6_ADDRESS =>
      val r = IPV6_ADDRESS
      r
    case software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType.MAC_ADDRESS =>
      val r = MAC_ADDRESS
      r
    case software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType.FQDN =>
      val r = FQDN
      r
    case software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType.VM_MANAGER_ID =>
      val r = VM_MANAGER_ID
      r
    case software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType.VM_MANAGED_OBJECT_REFERENCE =>
      val r = VM_MANAGED_OBJECT_REFERENCE
      r
    case software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType.VM_NAME =>
      val r = VM_NAME
      r
    case software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType.VM_PATH =>
      val r = VM_PATH
      r
    case software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType.BIOS_ID =>
      val r = BIOS_ID
      r
    case software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType.MOTHERBOARD_SERIAL_NUMBER =>
      val r = MOTHERBOARD_SERIAL_NUMBER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.migrationhub.model.ResourceAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType =
      software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType.UNKNOWN_TO_SDK_VERSION
  }
  case object IPV4_ADDRESS
      extends zio.aws.migrationhub.model.ResourceAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType =
      software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType.IPV4_ADDRESS
  }
  case object IPV6_ADDRESS
      extends zio.aws.migrationhub.model.ResourceAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType =
      software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType.IPV6_ADDRESS
  }
  case object MAC_ADDRESS
      extends zio.aws.migrationhub.model.ResourceAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType =
      software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType.MAC_ADDRESS
  }
  case object FQDN extends zio.aws.migrationhub.model.ResourceAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType =
      software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType.FQDN
  }
  case object VM_MANAGER_ID
      extends zio.aws.migrationhub.model.ResourceAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType =
      software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType.VM_MANAGER_ID
  }
  case object VM_MANAGED_OBJECT_REFERENCE
      extends zio.aws.migrationhub.model.ResourceAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType =
      software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType.VM_MANAGED_OBJECT_REFERENCE
  }
  case object VM_NAME extends zio.aws.migrationhub.model.ResourceAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType =
      software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType.VM_NAME
  }
  case object VM_PATH extends zio.aws.migrationhub.model.ResourceAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType =
      software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType.VM_PATH
  }
  case object BIOS_ID extends zio.aws.migrationhub.model.ResourceAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType =
      software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType.BIOS_ID
  }
  case object MOTHERBOARD_SERIAL_NUMBER
      extends zio.aws.migrationhub.model.ResourceAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType =
      software.amazon.awssdk.services.migrationhub.model.ResourceAttributeType.MOTHERBOARD_SERIAL_NUMBER
  }
}
