package zio.aws.migrationhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhub.model.primitives.{
  DryRun,
  MigrationTaskName,
  ProgressUpdateStream
}
import scala.jdk.CollectionConverters._
final case class AssociateCreatedArtifactRequest(
    progressUpdateStream: ProgressUpdateStream,
    migrationTaskName: MigrationTaskName,
    createdArtifact: zio.aws.migrationhub.model.CreatedArtifact,
    dryRun: Option[DryRun] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.AssociateCreatedArtifactRequest = {
    import AssociateCreatedArtifactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.AssociateCreatedArtifactRequest
      .builder()
      .progressUpdateStream(
        ProgressUpdateStream.unwrap(progressUpdateStream): java.lang.String
      )
      .migrationTaskName(
        MigrationTaskName.unwrap(migrationTaskName): java.lang.String
      )
      .createdArtifact(createdArtifact.buildAwsValue())
      .optionallyWith(
        dryRun.map(value => DryRun.unwrap(value): java.lang.Boolean)
      )(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhub.model.AssociateCreatedArtifactRequest.ReadOnly =
    zio.aws.migrationhub.model.AssociateCreatedArtifactRequest
      .wrap(buildAwsValue())
}
object AssociateCreatedArtifactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.AssociateCreatedArtifactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhub.model.AssociateCreatedArtifactRequest =
      zio.aws.migrationhub.model.AssociateCreatedArtifactRequest(
        progressUpdateStream,
        migrationTaskName,
        createdArtifact.asEditable,
        dryRun.map(value => value)
      )
    def progressUpdateStream: ProgressUpdateStream
    def migrationTaskName: MigrationTaskName
    def createdArtifact: zio.aws.migrationhub.model.CreatedArtifact.ReadOnly
    def dryRun: Option[DryRun]
    def getProgressUpdateStream: ZIO[Any, Nothing, ProgressUpdateStream] =
      ZIO.succeed(progressUpdateStream)
    def getMigrationTaskName: ZIO[Any, Nothing, MigrationTaskName] =
      ZIO.succeed(migrationTaskName)
    def getCreatedArtifact: ZIO[
      Any,
      Nothing,
      zio.aws.migrationhub.model.CreatedArtifact.ReadOnly
    ] = ZIO.succeed(createdArtifact)
    def getDryRun: ZIO[Any, AwsError, DryRun] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.AssociateCreatedArtifactRequest
  ) extends zio.aws.migrationhub.model.AssociateCreatedArtifactRequest.ReadOnly {
    override val progressUpdateStream: ProgressUpdateStream =
      zio.aws.migrationhub.model.primitives
        .ProgressUpdateStream(impl.progressUpdateStream())
    override val migrationTaskName: MigrationTaskName =
      zio.aws.migrationhub.model.primitives
        .MigrationTaskName(impl.migrationTaskName())
    override val createdArtifact
        : zio.aws.migrationhub.model.CreatedArtifact.ReadOnly =
      zio.aws.migrationhub.model.CreatedArtifact.wrap(impl.createdArtifact())
    override val dryRun: Option[DryRun] = scala
      .Option(impl.dryRun())
      .map(value => zio.aws.migrationhub.model.primitives.DryRun(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.AssociateCreatedArtifactRequest
  ): zio.aws.migrationhub.model.AssociateCreatedArtifactRequest.ReadOnly =
    new Wrapper(impl)
}
