package zio.aws.migrationhub
import zio.aws.migrationhub.model.ImportMigrationTaskResponse.ReadOnly
import zio.aws.core.AwsError
import software.amazon.awssdk.services.migrationhub.MigrationHubAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.migrationhub.model.{
  DisassociateDiscoveredResourceRequest,
  ImportMigrationTaskRequest,
  PutResourceAttributesRequest,
  DescribeMigrationTaskRequest,
  NotifyMigrationTaskStateRequest,
  ListMigrationTasksRequest,
  AssociateDiscoveredResourceRequest,
  DisassociateCreatedArtifactRequest,
  NotifyApplicationStateRequest,
  DeleteProgressUpdateStreamRequest,
  ListApplicationStatesRequest,
  DescribeApplicationStateRequest,
  ListDiscoveredResourcesRequest,
  CreateProgressUpdateStreamRequest,
  ListCreatedArtifactsRequest,
  AssociateCreatedArtifactRequest,
  ListProgressUpdateStreamsRequest
}
import zio.stream.ZStream
import zio.test.mock.{Proxy, Mock}
object MigrationHubMock extends Mock[MigrationHub] {
  object AssociateDiscoveredResource
      extends Effect[
        AssociateDiscoveredResourceRequest,
        AwsError,
        zio.aws.migrationhub.model.AssociateDiscoveredResourceResponse.ReadOnly
      ]
  object NotifyMigrationTaskState
      extends Effect[
        NotifyMigrationTaskStateRequest,
        AwsError,
        zio.aws.migrationhub.model.NotifyMigrationTaskStateResponse.ReadOnly
      ]
  object DisassociateDiscoveredResource
      extends Effect[
        DisassociateDiscoveredResourceRequest,
        AwsError,
        zio.aws.migrationhub.model.DisassociateDiscoveredResourceResponse.ReadOnly
      ]
  object ListMigrationTasks
      extends Stream[
        ListMigrationTasksRequest,
        AwsError,
        zio.aws.migrationhub.model.MigrationTaskSummary.ReadOnly
      ]
  object ListMigrationTasksPaginated
      extends Effect[
        ListMigrationTasksRequest,
        AwsError,
        zio.aws.migrationhub.model.ListMigrationTasksResponse.ReadOnly
      ]
  object AssociateCreatedArtifact
      extends Effect[
        AssociateCreatedArtifactRequest,
        AwsError,
        zio.aws.migrationhub.model.AssociateCreatedArtifactResponse.ReadOnly
      ]
  object CreateProgressUpdateStream
      extends Effect[
        CreateProgressUpdateStreamRequest,
        AwsError,
        zio.aws.migrationhub.model.CreateProgressUpdateStreamResponse.ReadOnly
      ]
  object PutResourceAttributes
      extends Effect[
        PutResourceAttributesRequest,
        AwsError,
        zio.aws.migrationhub.model.PutResourceAttributesResponse.ReadOnly
      ]
  object ListApplicationStates
      extends Stream[
        ListApplicationStatesRequest,
        AwsError,
        zio.aws.migrationhub.model.ApplicationState.ReadOnly
      ]
  object ListApplicationStatesPaginated
      extends Effect[
        ListApplicationStatesRequest,
        AwsError,
        zio.aws.migrationhub.model.ListApplicationStatesResponse.ReadOnly
      ]
  object DeleteProgressUpdateStream
      extends Effect[
        DeleteProgressUpdateStreamRequest,
        AwsError,
        zio.aws.migrationhub.model.DeleteProgressUpdateStreamResponse.ReadOnly
      ]
  object NotifyApplicationState
      extends Effect[
        NotifyApplicationStateRequest,
        AwsError,
        zio.aws.migrationhub.model.NotifyApplicationStateResponse.ReadOnly
      ]
  object ListCreatedArtifacts
      extends Stream[
        ListCreatedArtifactsRequest,
        AwsError,
        zio.aws.migrationhub.model.CreatedArtifact.ReadOnly
      ]
  object ListCreatedArtifactsPaginated
      extends Effect[
        ListCreatedArtifactsRequest,
        AwsError,
        zio.aws.migrationhub.model.ListCreatedArtifactsResponse.ReadOnly
      ]
  object DisassociateCreatedArtifact
      extends Effect[
        DisassociateCreatedArtifactRequest,
        AwsError,
        zio.aws.migrationhub.model.DisassociateCreatedArtifactResponse.ReadOnly
      ]
  object ImportMigrationTask
      extends Effect[ImportMigrationTaskRequest, AwsError, ReadOnly]
  object ListProgressUpdateStreams
      extends Stream[
        ListProgressUpdateStreamsRequest,
        AwsError,
        zio.aws.migrationhub.model.ProgressUpdateStreamSummary.ReadOnly
      ]
  object ListProgressUpdateStreamsPaginated
      extends Effect[
        ListProgressUpdateStreamsRequest,
        AwsError,
        zio.aws.migrationhub.model.ListProgressUpdateStreamsResponse.ReadOnly
      ]
  object DescribeMigrationTask
      extends Effect[
        DescribeMigrationTaskRequest,
        AwsError,
        zio.aws.migrationhub.model.DescribeMigrationTaskResponse.ReadOnly
      ]
  object ListDiscoveredResources
      extends Stream[
        ListDiscoveredResourcesRequest,
        AwsError,
        zio.aws.migrationhub.model.DiscoveredResource.ReadOnly
      ]
  object ListDiscoveredResourcesPaginated
      extends Effect[
        ListDiscoveredResourcesRequest,
        AwsError,
        zio.aws.migrationhub.model.ListDiscoveredResourcesResponse.ReadOnly
      ]
  object DescribeApplicationState
      extends Effect[
        DescribeApplicationStateRequest,
        AwsError,
        zio.aws.migrationhub.model.DescribeApplicationStateResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, MigrationHub] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new MigrationHub {
          val api: MigrationHubAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : MigrationHub = this
          def associateDiscoveredResource(
              request: AssociateDiscoveredResourceRequest
          ): IO[
            AwsError,
            zio.aws.migrationhub.model.AssociateDiscoveredResourceResponse.ReadOnly
          ] = proxy(AssociateDiscoveredResource, request)
          def notifyMigrationTaskState(
              request: NotifyMigrationTaskStateRequest
          ): IO[
            AwsError,
            zio.aws.migrationhub.model.NotifyMigrationTaskStateResponse.ReadOnly
          ] = proxy(NotifyMigrationTaskState, request)
          def disassociateDiscoveredResource(
              request: DisassociateDiscoveredResourceRequest
          ): IO[
            AwsError,
            zio.aws.migrationhub.model.DisassociateDiscoveredResourceResponse.ReadOnly
          ] = proxy(DisassociateDiscoveredResource, request)
          def listMigrationTasks(request: ListMigrationTasksRequest): ZStream[
            Any,
            AwsError,
            zio.aws.migrationhub.model.MigrationTaskSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListMigrationTasks, request))
          def listMigrationTasksPaginated(
              request: ListMigrationTasksRequest
          ): IO[
            AwsError,
            zio.aws.migrationhub.model.ListMigrationTasksResponse.ReadOnly
          ] = proxy(ListMigrationTasksPaginated, request)
          def associateCreatedArtifact(
              request: AssociateCreatedArtifactRequest
          ): IO[
            AwsError,
            zio.aws.migrationhub.model.AssociateCreatedArtifactResponse.ReadOnly
          ] = proxy(AssociateCreatedArtifact, request)
          def createProgressUpdateStream(
              request: CreateProgressUpdateStreamRequest
          ): IO[
            AwsError,
            zio.aws.migrationhub.model.CreateProgressUpdateStreamResponse.ReadOnly
          ] = proxy(CreateProgressUpdateStream, request)
          def putResourceAttributes(request: PutResourceAttributesRequest): IO[
            AwsError,
            zio.aws.migrationhub.model.PutResourceAttributesResponse.ReadOnly
          ] = proxy(PutResourceAttributes, request)
          def listApplicationStates(
              request: ListApplicationStatesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.migrationhub.model.ApplicationState.ReadOnly
          ] = rts.unsafeRun(proxy(ListApplicationStates, request))
          def listApplicationStatesPaginated(
              request: ListApplicationStatesRequest
          ): IO[
            AwsError,
            zio.aws.migrationhub.model.ListApplicationStatesResponse.ReadOnly
          ] = proxy(ListApplicationStatesPaginated, request)
          def deleteProgressUpdateStream(
              request: DeleteProgressUpdateStreamRequest
          ): IO[
            AwsError,
            zio.aws.migrationhub.model.DeleteProgressUpdateStreamResponse.ReadOnly
          ] = proxy(DeleteProgressUpdateStream, request)
          def notifyApplicationState(
              request: NotifyApplicationStateRequest
          ): IO[
            AwsError,
            zio.aws.migrationhub.model.NotifyApplicationStateResponse.ReadOnly
          ] = proxy(NotifyApplicationState, request)
          def listCreatedArtifacts(
              request: ListCreatedArtifactsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.migrationhub.model.CreatedArtifact.ReadOnly
          ] = rts.unsafeRun(proxy(ListCreatedArtifacts, request))
          def listCreatedArtifactsPaginated(
              request: ListCreatedArtifactsRequest
          ): IO[
            AwsError,
            zio.aws.migrationhub.model.ListCreatedArtifactsResponse.ReadOnly
          ] = proxy(ListCreatedArtifactsPaginated, request)
          def disassociateCreatedArtifact(
              request: DisassociateCreatedArtifactRequest
          ): IO[
            AwsError,
            zio.aws.migrationhub.model.DisassociateCreatedArtifactResponse.ReadOnly
          ] = proxy(DisassociateCreatedArtifact, request)
          def importMigrationTask(
              request: ImportMigrationTaskRequest
          ): IO[AwsError, ReadOnly] = proxy(ImportMigrationTask, request)
          def listProgressUpdateStreams(
              request: ListProgressUpdateStreamsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.migrationhub.model.ProgressUpdateStreamSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListProgressUpdateStreams, request))
          def listProgressUpdateStreamsPaginated(
              request: ListProgressUpdateStreamsRequest
          ): IO[
            AwsError,
            zio.aws.migrationhub.model.ListProgressUpdateStreamsResponse.ReadOnly
          ] = proxy(ListProgressUpdateStreamsPaginated, request)
          def describeMigrationTask(request: DescribeMigrationTaskRequest): IO[
            AwsError,
            zio.aws.migrationhub.model.DescribeMigrationTaskResponse.ReadOnly
          ] = proxy(DescribeMigrationTask, request)
          def listDiscoveredResources(
              request: ListDiscoveredResourcesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.migrationhub.model.DiscoveredResource.ReadOnly
          ] = rts.unsafeRun(proxy(ListDiscoveredResources, request))
          def listDiscoveredResourcesPaginated(
              request: ListDiscoveredResourcesRequest
          ): IO[
            AwsError,
            zio.aws.migrationhub.model.ListDiscoveredResourcesResponse.ReadOnly
          ] = proxy(ListDiscoveredResourcesPaginated, request)
          def describeApplicationState(
              request: DescribeApplicationStateRequest
          ): IO[
            AwsError,
            zio.aws.migrationhub.model.DescribeApplicationStateResponse.ReadOnly
          ] = proxy(DescribeApplicationState, request)
        }
      }
    }
    .toLayer
}
