package zio.aws.mgn.model
import scala.jdk.CollectionConverters._
sealed trait WaveProgressStatus {
  def unwrap: software.amazon.awssdk.services.mgn.model.WaveProgressStatus
}
object WaveProgressStatus {
  def wrap(
      value: software.amazon.awssdk.services.mgn.model.WaveProgressStatus
  ): zio.aws.mgn.model.WaveProgressStatus = value match {
    case software.amazon.awssdk.services.mgn.model.WaveProgressStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mgn.model.WaveProgressStatus.NOT_STARTED =>
      val r = NOT_STARTED
      r
    case software.amazon.awssdk.services.mgn.model.WaveProgressStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.mgn.model.WaveProgressStatus.COMPLETED =>
      val r = COMPLETED
      r
  }
  case object unknownToSdkVersion extends zio.aws.mgn.model.WaveProgressStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.WaveProgressStatus =
      software.amazon.awssdk.services.mgn.model.WaveProgressStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object NOT_STARTED extends zio.aws.mgn.model.WaveProgressStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.WaveProgressStatus =
      software.amazon.awssdk.services.mgn.model.WaveProgressStatus.NOT_STARTED
  }
  case object IN_PROGRESS extends zio.aws.mgn.model.WaveProgressStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.WaveProgressStatus =
      software.amazon.awssdk.services.mgn.model.WaveProgressStatus.IN_PROGRESS
  }
  case object COMPLETED extends zio.aws.mgn.model.WaveProgressStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.WaveProgressStatus =
      software.amazon.awssdk.services.mgn.model.WaveProgressStatus.COMPLETED
  }
}
