package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{
  WaveID,
  WaveName,
  WaveDescription,
  AccountID
}
import scala.jdk.CollectionConverters._
final case class UpdateWaveRequest(
    accountID: Optional[AccountID] = Optional.Absent,
    description: Optional[WaveDescription] = Optional.Absent,
    name: Optional[WaveName] = Optional.Absent,
    waveID: WaveID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.UpdateWaveRequest = {
    import UpdateWaveRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.UpdateWaveRequest
      .builder()
      .optionallyWith(
        accountID.map(value => AccountID.unwrap(value): java.lang.String)
      )(_.accountID)
      .optionallyWith(
        description.map(value =>
          WaveDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        name.map(value => WaveName.unwrap(value): java.lang.String)
      )(_.name)
      .waveID(WaveID.unwrap(waveID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.UpdateWaveRequest.ReadOnly =
    zio.aws.mgn.model.UpdateWaveRequest.wrap(buildAwsValue())
}
object UpdateWaveRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.UpdateWaveRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.UpdateWaveRequest =
      zio.aws.mgn.model.UpdateWaveRequest(
        accountID.map(value => value),
        description.map(value => value),
        name.map(value => value),
        waveID
      )
    def accountID: Optional[AccountID]
    def description: Optional[WaveDescription]
    def name: Optional[WaveName]
    def waveID: WaveID
    def getAccountID: ZIO[Any, AwsError, AccountID] =
      AwsError.unwrapOptionField("accountID", accountID)
    def getDescription: ZIO[Any, AwsError, WaveDescription] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, AwsError, WaveName] =
      AwsError.unwrapOptionField("name", name)
    def getWaveID: ZIO[Any, Nothing, WaveID] = ZIO.succeed(waveID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.UpdateWaveRequest
  ) extends zio.aws.mgn.model.UpdateWaveRequest.ReadOnly {
    override val accountID: Optional[AccountID] = zio.aws.core.internal
      .optionalFromNullable(impl.accountID())
      .map(value => zio.aws.mgn.model.primitives.AccountID(value))
    override val description: Optional[WaveDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.mgn.model.primitives.WaveDescription(value))
    override val name: Optional[WaveName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.mgn.model.primitives.WaveName(value))
    override val waveID: WaveID =
      zio.aws.mgn.model.primitives.WaveID(impl.waveID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.UpdateWaveRequest
  ): zio.aws.mgn.model.UpdateWaveRequest.ReadOnly = new Wrapper(impl)
}
