package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{SourceServerID, AccountID}
import scala.jdk.CollectionConverters._
final case class UpdateSourceServerRequest(
    accountID: Optional[AccountID] = Optional.Absent,
    connectorAction: Optional[zio.aws.mgn.model.SourceServerConnectorAction] =
      Optional.Absent,
    sourceServerID: SourceServerID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.UpdateSourceServerRequest = {
    import UpdateSourceServerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.UpdateSourceServerRequest
      .builder()
      .optionallyWith(
        accountID.map(value => AccountID.unwrap(value): java.lang.String)
      )(_.accountID)
      .optionallyWith(connectorAction.map(value => value.buildAwsValue()))(
        _.connectorAction
      )
      .sourceServerID(SourceServerID.unwrap(sourceServerID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.UpdateSourceServerRequest.ReadOnly =
    zio.aws.mgn.model.UpdateSourceServerRequest.wrap(buildAwsValue())
}
object UpdateSourceServerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.UpdateSourceServerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.UpdateSourceServerRequest =
      zio.aws.mgn.model.UpdateSourceServerRequest(
        accountID.map(value => value),
        connectorAction.map(value => value.asEditable),
        sourceServerID
      )
    def accountID: Optional[AccountID]
    def connectorAction
        : Optional[zio.aws.mgn.model.SourceServerConnectorAction.ReadOnly]
    def sourceServerID: SourceServerID
    def getAccountID: ZIO[Any, AwsError, AccountID] =
      AwsError.unwrapOptionField("accountID", accountID)
    def getConnectorAction: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.SourceServerConnectorAction.ReadOnly
    ] = AwsError.unwrapOptionField("connectorAction", connectorAction)
    def getSourceServerID: ZIO[Any, Nothing, SourceServerID] =
      ZIO.succeed(sourceServerID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.UpdateSourceServerRequest
  ) extends zio.aws.mgn.model.UpdateSourceServerRequest.ReadOnly {
    override val accountID: Optional[AccountID] = zio.aws.core.internal
      .optionalFromNullable(impl.accountID())
      .map(value => zio.aws.mgn.model.primitives.AccountID(value))
    override val connectorAction
        : Optional[zio.aws.mgn.model.SourceServerConnectorAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorAction())
        .map(value => zio.aws.mgn.model.SourceServerConnectorAction.wrap(value))
    override val sourceServerID: SourceServerID =
      zio.aws.mgn.model.primitives.SourceServerID(impl.sourceServerID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.UpdateSourceServerRequest
  ): zio.aws.mgn.model.UpdateSourceServerRequest.ReadOnly = new Wrapper(impl)
}
