package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{
  SubnetID,
  SecurityGroupID,
  TagValue,
  BandwidthThrottling,
  SourceServerID,
  EC2InstanceType,
  SmallBoundedString,
  ARN,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class UpdateReplicationConfigurationResponse(
    associateDefaultSecurityGroup: Optional[Boolean] = Optional.Absent,
    bandwidthThrottling: Optional[BandwidthThrottling] = Optional.Absent,
    createPublicIP: Optional[Boolean] = Optional.Absent,
    dataPlaneRouting: Optional[
      zio.aws.mgn.model.ReplicationConfigurationDataPlaneRouting
    ] = Optional.Absent,
    defaultLargeStagingDiskType: Optional[
      zio.aws.mgn.model.ReplicationConfigurationDefaultLargeStagingDiskType
    ] = Optional.Absent,
    ebsEncryption: Optional[
      zio.aws.mgn.model.ReplicationConfigurationEbsEncryption
    ] = Optional.Absent,
    ebsEncryptionKeyArn: Optional[ARN] = Optional.Absent,
    name: Optional[SmallBoundedString] = Optional.Absent,
    replicatedDisks: Optional[
      Iterable[zio.aws.mgn.model.ReplicationConfigurationReplicatedDisk]
    ] = Optional.Absent,
    replicationServerInstanceType: Optional[EC2InstanceType] = Optional.Absent,
    replicationServersSecurityGroupsIDs: Optional[Iterable[SecurityGroupID]] =
      Optional.Absent,
    sourceServerID: Optional[SourceServerID] = Optional.Absent,
    stagingAreaSubnetId: Optional[SubnetID] = Optional.Absent,
    stagingAreaTags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    useDedicatedReplicationServer: Optional[Boolean] = Optional.Absent,
    useFipsEndpoint: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.UpdateReplicationConfigurationResponse = {
    import UpdateReplicationConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.UpdateReplicationConfigurationResponse
      .builder()
      .optionallyWith(
        associateDefaultSecurityGroup.map(value => value: java.lang.Boolean)
      )(_.associateDefaultSecurityGroup)
      .optionallyWith(
        bandwidthThrottling.map(value =>
          BandwidthThrottling.unwrap(value): java.lang.Long
        )
      )(_.bandwidthThrottling)
      .optionallyWith(createPublicIP.map(value => value: java.lang.Boolean))(
        _.createPublicIP
      )
      .optionallyWith(dataPlaneRouting.map(value => value.unwrap))(
        _.dataPlaneRouting
      )
      .optionallyWith(defaultLargeStagingDiskType.map(value => value.unwrap))(
        _.defaultLargeStagingDiskType
      )
      .optionallyWith(ebsEncryption.map(value => value.unwrap))(_.ebsEncryption)
      .optionallyWith(
        ebsEncryptionKeyArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.ebsEncryptionKeyArn)
      .optionallyWith(
        name.map(value => SmallBoundedString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        replicatedDisks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicatedDisks)
      .optionallyWith(
        replicationServerInstanceType.map(value =>
          EC2InstanceType.unwrap(value): java.lang.String
        )
      )(_.replicationServerInstanceType)
      .optionallyWith(
        replicationServersSecurityGroupsIDs.map(value =>
          value.map { item =>
            SecurityGroupID.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.replicationServersSecurityGroupsIDs)
      .optionallyWith(
        sourceServerID.map(value =>
          SourceServerID.unwrap(value): java.lang.String
        )
      )(_.sourceServerID)
      .optionallyWith(
        stagingAreaSubnetId.map(value =>
          SubnetID.unwrap(value): java.lang.String
        )
      )(_.stagingAreaSubnetId)
      .optionallyWith(
        stagingAreaTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.stagingAreaTags)
      .optionallyWith(
        useDedicatedReplicationServer.map(value => value: java.lang.Boolean)
      )(_.useDedicatedReplicationServer)
      .optionallyWith(useFipsEndpoint.map(value => value: java.lang.Boolean))(
        _.useFipsEndpoint
      )
      .build()
  }
  def asReadOnly
      : zio.aws.mgn.model.UpdateReplicationConfigurationResponse.ReadOnly =
    zio.aws.mgn.model.UpdateReplicationConfigurationResponse
      .wrap(buildAwsValue())
}
object UpdateReplicationConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.UpdateReplicationConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.UpdateReplicationConfigurationResponse =
      zio.aws.mgn.model.UpdateReplicationConfigurationResponse(
        associateDefaultSecurityGroup.map(value => value),
        bandwidthThrottling.map(value => value),
        createPublicIP.map(value => value),
        dataPlaneRouting.map(value => value),
        defaultLargeStagingDiskType.map(value => value),
        ebsEncryption.map(value => value),
        ebsEncryptionKeyArn.map(value => value),
        name.map(value => value),
        replicatedDisks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        replicationServerInstanceType.map(value => value),
        replicationServersSecurityGroupsIDs.map(value => value),
        sourceServerID.map(value => value),
        stagingAreaSubnetId.map(value => value),
        stagingAreaTags.map(value => value),
        useDedicatedReplicationServer.map(value => value),
        useFipsEndpoint.map(value => value)
      )
    def associateDefaultSecurityGroup: Optional[Boolean]
    def bandwidthThrottling: Optional[BandwidthThrottling]
    def createPublicIP: Optional[Boolean]
    def dataPlaneRouting
        : Optional[zio.aws.mgn.model.ReplicationConfigurationDataPlaneRouting]
    def defaultLargeStagingDiskType: Optional[
      zio.aws.mgn.model.ReplicationConfigurationDefaultLargeStagingDiskType
    ]
    def ebsEncryption
        : Optional[zio.aws.mgn.model.ReplicationConfigurationEbsEncryption]
    def ebsEncryptionKeyArn: Optional[ARN]
    def name: Optional[SmallBoundedString]
    def replicatedDisks: Optional[
      List[zio.aws.mgn.model.ReplicationConfigurationReplicatedDisk.ReadOnly]
    ]
    def replicationServerInstanceType: Optional[EC2InstanceType]
    def replicationServersSecurityGroupsIDs: Optional[List[SecurityGroupID]]
    def sourceServerID: Optional[SourceServerID]
    def stagingAreaSubnetId: Optional[SubnetID]
    def stagingAreaTags: Optional[Map[TagKey, TagValue]]
    def useDedicatedReplicationServer: Optional[Boolean]
    def useFipsEndpoint: Optional[Boolean]
    def getAssociateDefaultSecurityGroup: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "associateDefaultSecurityGroup",
        associateDefaultSecurityGroup
      )
    def getBandwidthThrottling: ZIO[Any, AwsError, BandwidthThrottling] =
      AwsError.unwrapOptionField("bandwidthThrottling", bandwidthThrottling)
    def getCreatePublicIP: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("createPublicIP", createPublicIP)
    def getDataPlaneRouting: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.ReplicationConfigurationDataPlaneRouting
    ] = AwsError.unwrapOptionField("dataPlaneRouting", dataPlaneRouting)
    def getDefaultLargeStagingDiskType: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.ReplicationConfigurationDefaultLargeStagingDiskType
    ] = AwsError.unwrapOptionField(
      "defaultLargeStagingDiskType",
      defaultLargeStagingDiskType
    )
    def getEbsEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.ReplicationConfigurationEbsEncryption
    ] = AwsError.unwrapOptionField("ebsEncryption", ebsEncryption)
    def getEbsEncryptionKeyArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("ebsEncryptionKeyArn", ebsEncryptionKeyArn)
    def getName: ZIO[Any, AwsError, SmallBoundedString] =
      AwsError.unwrapOptionField("name", name)
    def getReplicatedDisks: ZIO[Any, AwsError, List[
      zio.aws.mgn.model.ReplicationConfigurationReplicatedDisk.ReadOnly
    ]] = AwsError.unwrapOptionField("replicatedDisks", replicatedDisks)
    def getReplicationServerInstanceType: ZIO[Any, AwsError, EC2InstanceType] =
      AwsError.unwrapOptionField(
        "replicationServerInstanceType",
        replicationServerInstanceType
      )
    def getReplicationServersSecurityGroupsIDs
        : ZIO[Any, AwsError, List[SecurityGroupID]] =
      AwsError.unwrapOptionField(
        "replicationServersSecurityGroupsIDs",
        replicationServersSecurityGroupsIDs
      )
    def getSourceServerID: ZIO[Any, AwsError, SourceServerID] =
      AwsError.unwrapOptionField("sourceServerID", sourceServerID)
    def getStagingAreaSubnetId: ZIO[Any, AwsError, SubnetID] =
      AwsError.unwrapOptionField("stagingAreaSubnetId", stagingAreaSubnetId)
    def getStagingAreaTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("stagingAreaTags", stagingAreaTags)
    def getUseDedicatedReplicationServer: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "useDedicatedReplicationServer",
        useDedicatedReplicationServer
      )
    def getUseFipsEndpoint: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("useFipsEndpoint", useFipsEndpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.UpdateReplicationConfigurationResponse
  ) extends zio.aws.mgn.model.UpdateReplicationConfigurationResponse.ReadOnly {
    override val associateDefaultSecurityGroup: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associateDefaultSecurityGroup())
        .map(value => value: Boolean)
    override val bandwidthThrottling: Optional[BandwidthThrottling] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bandwidthThrottling())
        .map(value => zio.aws.mgn.model.primitives.BandwidthThrottling(value))
    override val createPublicIP: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.createPublicIP())
      .map(value => value: Boolean)
    override val dataPlaneRouting
        : Optional[zio.aws.mgn.model.ReplicationConfigurationDataPlaneRouting] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataPlaneRouting())
        .map(value =>
          zio.aws.mgn.model.ReplicationConfigurationDataPlaneRouting.wrap(value)
        )
    override val defaultLargeStagingDiskType: Optional[
      zio.aws.mgn.model.ReplicationConfigurationDefaultLargeStagingDiskType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultLargeStagingDiskType())
      .map(value =>
        zio.aws.mgn.model.ReplicationConfigurationDefaultLargeStagingDiskType
          .wrap(value)
      )
    override val ebsEncryption
        : Optional[zio.aws.mgn.model.ReplicationConfigurationEbsEncryption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ebsEncryption())
        .map(value =>
          zio.aws.mgn.model.ReplicationConfigurationEbsEncryption.wrap(value)
        )
    override val ebsEncryptionKeyArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.ebsEncryptionKeyArn())
      .map(value => zio.aws.mgn.model.primitives.ARN(value))
    override val name: Optional[SmallBoundedString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.mgn.model.primitives.SmallBoundedString(value))
    override val replicatedDisks: Optional[
      List[zio.aws.mgn.model.ReplicationConfigurationReplicatedDisk.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.replicatedDisks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mgn.model.ReplicationConfigurationReplicatedDisk.wrap(item)
        }.toList
      )
    override val replicationServerInstanceType: Optional[EC2InstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationServerInstanceType())
        .map(value => zio.aws.mgn.model.primitives.EC2InstanceType(value))
    override val replicationServersSecurityGroupsIDs
        : Optional[List[SecurityGroupID]] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationServersSecurityGroupsIDs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mgn.model.primitives.SecurityGroupID(item)
        }.toList
      )
    override val sourceServerID: Optional[SourceServerID] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceServerID())
        .map(value => zio.aws.mgn.model.primitives.SourceServerID(value))
    override val stagingAreaSubnetId: Optional[SubnetID] = zio.aws.core.internal
      .optionalFromNullable(impl.stagingAreaSubnetId())
      .map(value => zio.aws.mgn.model.primitives.SubnetID(value))
    override val stagingAreaTags: Optional[Map[TagKey, TagValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stagingAreaTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.mgn.model.primitives
                .TagKey(key) -> zio.aws.mgn.model.primitives.TagValue(value)
            })
            .toMap
        )
    override val useDedicatedReplicationServer: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.useDedicatedReplicationServer())
        .map(value => value: Boolean)
    override val useFipsEndpoint: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.useFipsEndpoint())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.UpdateReplicationConfigurationResponse
  ): zio.aws.mgn.model.UpdateReplicationConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
