package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{ConnectorName, ConnectorID}
import scala.jdk.CollectionConverters._
final case class UpdateConnectorRequest(
    connectorID: ConnectorID,
    name: Optional[ConnectorName] = Optional.Absent,
    ssmCommandConfig: Optional[zio.aws.mgn.model.ConnectorSsmCommandConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.UpdateConnectorRequest = {
    import UpdateConnectorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.UpdateConnectorRequest
      .builder()
      .connectorID(ConnectorID.unwrap(connectorID): java.lang.String)
      .optionallyWith(
        name.map(value => ConnectorName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(ssmCommandConfig.map(value => value.buildAwsValue()))(
        _.ssmCommandConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.UpdateConnectorRequest.ReadOnly =
    zio.aws.mgn.model.UpdateConnectorRequest.wrap(buildAwsValue())
}
object UpdateConnectorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.UpdateConnectorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.UpdateConnectorRequest =
      zio.aws.mgn.model.UpdateConnectorRequest(
        connectorID,
        name.map(value => value),
        ssmCommandConfig.map(value => value.asEditable)
      )
    def connectorID: ConnectorID
    def name: Optional[ConnectorName]
    def ssmCommandConfig
        : Optional[zio.aws.mgn.model.ConnectorSsmCommandConfig.ReadOnly]
    def getConnectorID: ZIO[Any, Nothing, ConnectorID] =
      ZIO.succeed(connectorID)
    def getName: ZIO[Any, AwsError, ConnectorName] =
      AwsError.unwrapOptionField("name", name)
    def getSsmCommandConfig: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.ConnectorSsmCommandConfig.ReadOnly
    ] = AwsError.unwrapOptionField("ssmCommandConfig", ssmCommandConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.UpdateConnectorRequest
  ) extends zio.aws.mgn.model.UpdateConnectorRequest.ReadOnly {
    override val connectorID: ConnectorID =
      zio.aws.mgn.model.primitives.ConnectorID(impl.connectorID())
    override val name: Optional[ConnectorName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.mgn.model.primitives.ConnectorName(value))
    override val ssmCommandConfig
        : Optional[zio.aws.mgn.model.ConnectorSsmCommandConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ssmCommandConfig())
        .map(value => zio.aws.mgn.model.ConnectorSsmCommandConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.UpdateConnectorRequest
  ): zio.aws.mgn.model.UpdateConnectorRequest.ReadOnly = new Wrapper(impl)
}
