package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{ApplicationID, AccountID}
import scala.jdk.CollectionConverters._
final case class UnarchiveApplicationRequest(
    accountID: Optional[AccountID] = Optional.Absent,
    applicationID: ApplicationID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.UnarchiveApplicationRequest = {
    import UnarchiveApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.UnarchiveApplicationRequest
      .builder()
      .optionallyWith(
        accountID.map(value => AccountID.unwrap(value): java.lang.String)
      )(_.accountID)
      .applicationID(ApplicationID.unwrap(applicationID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.UnarchiveApplicationRequest.ReadOnly =
    zio.aws.mgn.model.UnarchiveApplicationRequest.wrap(buildAwsValue())
}
object UnarchiveApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.UnarchiveApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.UnarchiveApplicationRequest =
      zio.aws.mgn.model.UnarchiveApplicationRequest(
        accountID.map(value => value),
        applicationID
      )
    def accountID: Optional[AccountID]
    def applicationID: ApplicationID
    def getAccountID: ZIO[Any, AwsError, AccountID] =
      AwsError.unwrapOptionField("accountID", accountID)
    def getApplicationID: ZIO[Any, Nothing, ApplicationID] =
      ZIO.succeed(applicationID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.UnarchiveApplicationRequest
  ) extends zio.aws.mgn.model.UnarchiveApplicationRequest.ReadOnly {
    override val accountID: Optional[AccountID] = zio.aws.core.internal
      .optionalFromNullable(impl.accountID())
      .map(value => zio.aws.mgn.model.primitives.AccountID(value))
    override val applicationID: ApplicationID =
      zio.aws.mgn.model.primitives.ApplicationID(impl.applicationID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.UnarchiveApplicationRequest
  ): zio.aws.mgn.model.UnarchiveApplicationRequest.ReadOnly = new Wrapper(impl)
}
