package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{S3Key, AccountID, S3BucketName}
import scala.jdk.CollectionConverters._
final case class StartExportRequest(
    s3Bucket: S3BucketName,
    s3BucketOwner: Optional[AccountID] = Optional.Absent,
    s3Key: S3Key
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.StartExportRequest = {
    import StartExportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.StartExportRequest
      .builder()
      .s3Bucket(S3BucketName.unwrap(s3Bucket): java.lang.String)
      .optionallyWith(
        s3BucketOwner.map(value => AccountID.unwrap(value): java.lang.String)
      )(_.s3BucketOwner)
      .s3Key(S3Key.unwrap(s3Key): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.StartExportRequest.ReadOnly =
    zio.aws.mgn.model.StartExportRequest.wrap(buildAwsValue())
}
object StartExportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.StartExportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.StartExportRequest = zio.aws.mgn.model
      .StartExportRequest(s3Bucket, s3BucketOwner.map(value => value), s3Key)
    def s3Bucket: S3BucketName
    def s3BucketOwner: Optional[AccountID]
    def s3Key: S3Key
    def getS3Bucket: ZIO[Any, Nothing, S3BucketName] = ZIO.succeed(s3Bucket)
    def getS3BucketOwner: ZIO[Any, AwsError, AccountID] =
      AwsError.unwrapOptionField("s3BucketOwner", s3BucketOwner)
    def getS3Key: ZIO[Any, Nothing, S3Key] = ZIO.succeed(s3Key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.StartExportRequest
  ) extends zio.aws.mgn.model.StartExportRequest.ReadOnly {
    override val s3Bucket: S3BucketName =
      zio.aws.mgn.model.primitives.S3BucketName(impl.s3Bucket())
    override val s3BucketOwner: Optional[AccountID] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BucketOwner())
      .map(value => zio.aws.mgn.model.primitives.AccountID(value))
    override val s3Key: S3Key = zio.aws.mgn.model.primitives.S3Key(impl.s3Key())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.StartExportRequest
  ): zio.aws.mgn.model.StartExportRequest.ReadOnly = new Wrapper(impl)
}
