package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{
  TagValue,
  TagKey,
  SourceServerID,
  AccountID
}
import scala.jdk.CollectionConverters._
final case class StartCutoverRequest(
    accountID: Optional[AccountID] = Optional.Absent,
    sourceServerIDs: Iterable[SourceServerID],
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.StartCutoverRequest = {
    import StartCutoverRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.StartCutoverRequest
      .builder()
      .optionallyWith(
        accountID.map(value => AccountID.unwrap(value): java.lang.String)
      )(_.accountID)
      .sourceServerIDs(sourceServerIDs.map { item =>
        SourceServerID.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.StartCutoverRequest.ReadOnly =
    zio.aws.mgn.model.StartCutoverRequest.wrap(buildAwsValue())
}
object StartCutoverRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.StartCutoverRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.StartCutoverRequest =
      zio.aws.mgn.model.StartCutoverRequest(
        accountID.map(value => value),
        sourceServerIDs,
        tags.map(value => value)
      )
    def accountID: Optional[AccountID]
    def sourceServerIDs: List[SourceServerID]
    def tags: Optional[Map[TagKey, TagValue]]
    def getAccountID: ZIO[Any, AwsError, AccountID] =
      AwsError.unwrapOptionField("accountID", accountID)
    def getSourceServerIDs: ZIO[Any, Nothing, List[SourceServerID]] =
      ZIO.succeed(sourceServerIDs)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.StartCutoverRequest
  ) extends zio.aws.mgn.model.StartCutoverRequest.ReadOnly {
    override val accountID: Optional[AccountID] = zio.aws.core.internal
      .optionalFromNullable(impl.accountID())
      .map(value => zio.aws.mgn.model.primitives.AccountID(value))
    override val sourceServerIDs: List[SourceServerID] = impl
      .sourceServerIDs()
      .asScala
      .map { item =>
        zio.aws.mgn.model.primitives.SourceServerID(item)
      }
      .toList
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mgn.model.primitives
              .TagKey(key) -> zio.aws.mgn.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.StartCutoverRequest
  ): zio.aws.mgn.model.StartCutoverRequest.ReadOnly = new Wrapper(impl)
}
