package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{SecretArn, ConnectorArn}
import scala.jdk.CollectionConverters._
final case class SourceServerConnectorAction(
    connectorArn: Optional[ConnectorArn] = Optional.Absent,
    credentialsSecretArn: Optional[SecretArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.SourceServerConnectorAction = {
    import SourceServerConnectorAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.SourceServerConnectorAction
      .builder()
      .optionallyWith(
        connectorArn.map(value => ConnectorArn.unwrap(value): java.lang.String)
      )(_.connectorArn)
      .optionallyWith(
        credentialsSecretArn.map(value =>
          SecretArn.unwrap(value): java.lang.String
        )
      )(_.credentialsSecretArn)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.SourceServerConnectorAction.ReadOnly =
    zio.aws.mgn.model.SourceServerConnectorAction.wrap(buildAwsValue())
}
object SourceServerConnectorAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.SourceServerConnectorAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.SourceServerConnectorAction =
      zio.aws.mgn.model.SourceServerConnectorAction(
        connectorArn.map(value => value),
        credentialsSecretArn.map(value => value)
      )
    def connectorArn: Optional[ConnectorArn]
    def credentialsSecretArn: Optional[SecretArn]
    def getConnectorArn: ZIO[Any, AwsError, ConnectorArn] =
      AwsError.unwrapOptionField("connectorArn", connectorArn)
    def getCredentialsSecretArn: ZIO[Any, AwsError, SecretArn] =
      AwsError.unwrapOptionField("credentialsSecretArn", credentialsSecretArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.SourceServerConnectorAction
  ) extends zio.aws.mgn.model.SourceServerConnectorAction.ReadOnly {
    override val connectorArn: Optional[ConnectorArn] = zio.aws.core.internal
      .optionalFromNullable(impl.connectorArn())
      .map(value => zio.aws.mgn.model.primitives.ConnectorArn(value))
    override val credentialsSecretArn: Optional[SecretArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.credentialsSecretArn())
        .map(value => zio.aws.mgn.model.primitives.SecretArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.SourceServerConnectorAction
  ): zio.aws.mgn.model.SourceServerConnectorAction.ReadOnly = new Wrapper(impl)
}
