package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{
  BoundedString,
  TagValue,
  VcenterClientID,
  SourceServerID,
  ApplicationID,
  ARN,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class PauseReplicationResponse(
    applicationID: Optional[ApplicationID] = Optional.Absent,
    arn: Optional[ARN] = Optional.Absent,
    connectorAction: Optional[zio.aws.mgn.model.SourceServerConnectorAction] =
      Optional.Absent,
    dataReplicationInfo: Optional[zio.aws.mgn.model.DataReplicationInfo] =
      Optional.Absent,
    fqdnForActionFramework: Optional[BoundedString] = Optional.Absent,
    isArchived: Optional[Boolean] = Optional.Absent,
    launchedInstance: Optional[zio.aws.mgn.model.LaunchedInstance] =
      Optional.Absent,
    lifeCycle: Optional[zio.aws.mgn.model.LifeCycle] = Optional.Absent,
    replicationType: Optional[zio.aws.mgn.model.ReplicationType] =
      Optional.Absent,
    sourceProperties: Optional[zio.aws.mgn.model.SourceProperties] =
      Optional.Absent,
    sourceServerID: Optional[SourceServerID] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    userProvidedID: Optional[BoundedString] = Optional.Absent,
    vcenterClientID: Optional[VcenterClientID] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.PauseReplicationResponse = {
    import PauseReplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.PauseReplicationResponse
      .builder()
      .optionallyWith(
        applicationID.map(value =>
          ApplicationID.unwrap(value): java.lang.String
        )
      )(_.applicationID)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(connectorAction.map(value => value.buildAwsValue()))(
        _.connectorAction
      )
      .optionallyWith(dataReplicationInfo.map(value => value.buildAwsValue()))(
        _.dataReplicationInfo
      )
      .optionallyWith(
        fqdnForActionFramework.map(value =>
          BoundedString.unwrap(value): java.lang.String
        )
      )(_.fqdnForActionFramework)
      .optionallyWith(isArchived.map(value => value: java.lang.Boolean))(
        _.isArchived
      )
      .optionallyWith(launchedInstance.map(value => value.buildAwsValue()))(
        _.launchedInstance
      )
      .optionallyWith(lifeCycle.map(value => value.buildAwsValue()))(
        _.lifeCycle
      )
      .optionallyWith(replicationType.map(value => value.unwrap))(
        _.replicationType
      )
      .optionallyWith(sourceProperties.map(value => value.buildAwsValue()))(
        _.sourceProperties
      )
      .optionallyWith(
        sourceServerID.map(value =>
          SourceServerID.unwrap(value): java.lang.String
        )
      )(_.sourceServerID)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        userProvidedID.map(value =>
          BoundedString.unwrap(value): java.lang.String
        )
      )(_.userProvidedID)
      .optionallyWith(
        vcenterClientID.map(value =>
          VcenterClientID.unwrap(value): java.lang.String
        )
      )(_.vcenterClientID)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.PauseReplicationResponse.ReadOnly =
    zio.aws.mgn.model.PauseReplicationResponse.wrap(buildAwsValue())
}
object PauseReplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.PauseReplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.PauseReplicationResponse =
      zio.aws.mgn.model.PauseReplicationResponse(
        applicationID.map(value => value),
        arn.map(value => value),
        connectorAction.map(value => value.asEditable),
        dataReplicationInfo.map(value => value.asEditable),
        fqdnForActionFramework.map(value => value),
        isArchived.map(value => value),
        launchedInstance.map(value => value.asEditable),
        lifeCycle.map(value => value.asEditable),
        replicationType.map(value => value),
        sourceProperties.map(value => value.asEditable),
        sourceServerID.map(value => value),
        tags.map(value => value),
        userProvidedID.map(value => value),
        vcenterClientID.map(value => value)
      )
    def applicationID: Optional[ApplicationID]
    def arn: Optional[ARN]
    def connectorAction
        : Optional[zio.aws.mgn.model.SourceServerConnectorAction.ReadOnly]
    def dataReplicationInfo
        : Optional[zio.aws.mgn.model.DataReplicationInfo.ReadOnly]
    def fqdnForActionFramework: Optional[BoundedString]
    def isArchived: Optional[Boolean]
    def launchedInstance: Optional[zio.aws.mgn.model.LaunchedInstance.ReadOnly]
    def lifeCycle: Optional[zio.aws.mgn.model.LifeCycle.ReadOnly]
    def replicationType: Optional[zio.aws.mgn.model.ReplicationType]
    def sourceProperties: Optional[zio.aws.mgn.model.SourceProperties.ReadOnly]
    def sourceServerID: Optional[SourceServerID]
    def tags: Optional[Map[TagKey, TagValue]]
    def userProvidedID: Optional[BoundedString]
    def vcenterClientID: Optional[VcenterClientID]
    def getApplicationID: ZIO[Any, AwsError, ApplicationID] =
      AwsError.unwrapOptionField("applicationID", applicationID)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getConnectorAction: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.SourceServerConnectorAction.ReadOnly
    ] = AwsError.unwrapOptionField("connectorAction", connectorAction)
    def getDataReplicationInfo
        : ZIO[Any, AwsError, zio.aws.mgn.model.DataReplicationInfo.ReadOnly] =
      AwsError.unwrapOptionField("dataReplicationInfo", dataReplicationInfo)
    def getFqdnForActionFramework: ZIO[Any, AwsError, BoundedString] = AwsError
      .unwrapOptionField("fqdnForActionFramework", fqdnForActionFramework)
    def getIsArchived: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isArchived", isArchived)
    def getLaunchedInstance
        : ZIO[Any, AwsError, zio.aws.mgn.model.LaunchedInstance.ReadOnly] =
      AwsError.unwrapOptionField("launchedInstance", launchedInstance)
    def getLifeCycle: ZIO[Any, AwsError, zio.aws.mgn.model.LifeCycle.ReadOnly] =
      AwsError.unwrapOptionField("lifeCycle", lifeCycle)
    def getReplicationType
        : ZIO[Any, AwsError, zio.aws.mgn.model.ReplicationType] =
      AwsError.unwrapOptionField("replicationType", replicationType)
    def getSourceProperties
        : ZIO[Any, AwsError, zio.aws.mgn.model.SourceProperties.ReadOnly] =
      AwsError.unwrapOptionField("sourceProperties", sourceProperties)
    def getSourceServerID: ZIO[Any, AwsError, SourceServerID] =
      AwsError.unwrapOptionField("sourceServerID", sourceServerID)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUserProvidedID: ZIO[Any, AwsError, BoundedString] =
      AwsError.unwrapOptionField("userProvidedID", userProvidedID)
    def getVcenterClientID: ZIO[Any, AwsError, VcenterClientID] =
      AwsError.unwrapOptionField("vcenterClientID", vcenterClientID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.PauseReplicationResponse
  ) extends zio.aws.mgn.model.PauseReplicationResponse.ReadOnly {
    override val applicationID: Optional[ApplicationID] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationID())
      .map(value => zio.aws.mgn.model.primitives.ApplicationID(value))
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.mgn.model.primitives.ARN(value))
    override val connectorAction
        : Optional[zio.aws.mgn.model.SourceServerConnectorAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorAction())
        .map(value => zio.aws.mgn.model.SourceServerConnectorAction.wrap(value))
    override val dataReplicationInfo
        : Optional[zio.aws.mgn.model.DataReplicationInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataReplicationInfo())
        .map(value => zio.aws.mgn.model.DataReplicationInfo.wrap(value))
    override val fqdnForActionFramework: Optional[BoundedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fqdnForActionFramework())
        .map(value => zio.aws.mgn.model.primitives.BoundedString(value))
    override val isArchived: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isArchived())
      .map(value => value: Boolean)
    override val launchedInstance
        : Optional[zio.aws.mgn.model.LaunchedInstance.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchedInstance())
        .map(value => zio.aws.mgn.model.LaunchedInstance.wrap(value))
    override val lifeCycle: Optional[zio.aws.mgn.model.LifeCycle.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifeCycle())
        .map(value => zio.aws.mgn.model.LifeCycle.wrap(value))
    override val replicationType: Optional[zio.aws.mgn.model.ReplicationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationType())
        .map(value => zio.aws.mgn.model.ReplicationType.wrap(value))
    override val sourceProperties
        : Optional[zio.aws.mgn.model.SourceProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceProperties())
        .map(value => zio.aws.mgn.model.SourceProperties.wrap(value))
    override val sourceServerID: Optional[SourceServerID] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceServerID())
        .map(value => zio.aws.mgn.model.primitives.SourceServerID(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mgn.model.primitives
              .TagKey(key) -> zio.aws.mgn.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val userProvidedID: Optional[BoundedString] = zio.aws.core.internal
      .optionalFromNullable(impl.userProvidedID())
      .map(value => zio.aws.mgn.model.primitives.BoundedString(value))
    override val vcenterClientID: Optional[VcenterClientID] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vcenterClientID())
        .map(value => zio.aws.mgn.model.primitives.VcenterClientID(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.PauseReplicationResponse
  ): zio.aws.mgn.model.PauseReplicationResponse.ReadOnly = new Wrapper(impl)
}
