package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{SourceServerID, AccountID}
import scala.jdk.CollectionConverters._
final case class MarkAsArchivedRequest(
    accountID: Optional[AccountID] = Optional.Absent,
    sourceServerID: SourceServerID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.MarkAsArchivedRequest = {
    import MarkAsArchivedRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.MarkAsArchivedRequest
      .builder()
      .optionallyWith(
        accountID.map(value => AccountID.unwrap(value): java.lang.String)
      )(_.accountID)
      .sourceServerID(SourceServerID.unwrap(sourceServerID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.MarkAsArchivedRequest.ReadOnly =
    zio.aws.mgn.model.MarkAsArchivedRequest.wrap(buildAwsValue())
}
object MarkAsArchivedRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.MarkAsArchivedRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.MarkAsArchivedRequest = zio.aws.mgn.model
      .MarkAsArchivedRequest(accountID.map(value => value), sourceServerID)
    def accountID: Optional[AccountID]
    def sourceServerID: SourceServerID
    def getAccountID: ZIO[Any, AwsError, AccountID] =
      AwsError.unwrapOptionField("accountID", accountID)
    def getSourceServerID: ZIO[Any, Nothing, SourceServerID] =
      ZIO.succeed(sourceServerID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.MarkAsArchivedRequest
  ) extends zio.aws.mgn.model.MarkAsArchivedRequest.ReadOnly {
    override val accountID: Optional[AccountID] = zio.aws.core.internal
      .optionalFromNullable(impl.accountID())
      .map(value => zio.aws.mgn.model.primitives.AccountID(value))
    override val sourceServerID: SourceServerID =
      zio.aws.mgn.model.primitives.SourceServerID(impl.sourceServerID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.MarkAsArchivedRequest
  ): zio.aws.mgn.model.MarkAsArchivedRequest.ReadOnly = new Wrapper(impl)
}
