package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListConnectorsResponse(
    items: Optional[Iterable[zio.aws.mgn.model.Connector]] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ListConnectorsResponse = {
    import ListConnectorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ListConnectorsResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ListConnectorsResponse.ReadOnly =
    zio.aws.mgn.model.ListConnectorsResponse.wrap(buildAwsValue())
}
object ListConnectorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ListConnectorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ListConnectorsResponse =
      zio.aws.mgn.model.ListConnectorsResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Optional[List[zio.aws.mgn.model.Connector.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getItems
        : ZIO[Any, AwsError, List[zio.aws.mgn.model.Connector.ReadOnly]] =
      AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ListConnectorsResponse
  ) extends zio.aws.mgn.model.ListConnectorsResponse.ReadOnly {
    override val items: Optional[List[zio.aws.mgn.model.Connector.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mgn.model.Connector.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.mgn.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ListConnectorsResponse
  ): zio.aws.mgn.model.ListConnectorsResponse.ReadOnly = new Wrapper(impl)
}
