package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.ConnectorID
import scala.jdk.CollectionConverters._
final case class ListConnectorsRequestFilters(
    connectorIDs: Optional[Iterable[ConnectorID]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ListConnectorsRequestFilters = {
    import ListConnectorsRequestFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ListConnectorsRequestFilters
      .builder()
      .optionallyWith(
        connectorIDs.map(value =>
          value.map { item =>
            ConnectorID.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.connectorIDs)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ListConnectorsRequestFilters.ReadOnly =
    zio.aws.mgn.model.ListConnectorsRequestFilters.wrap(buildAwsValue())
}
object ListConnectorsRequestFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ListConnectorsRequestFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ListConnectorsRequestFilters =
      zio.aws.mgn.model
        .ListConnectorsRequestFilters(connectorIDs.map(value => value))
    def connectorIDs: Optional[List[ConnectorID]]
    def getConnectorIDs: ZIO[Any, AwsError, List[ConnectorID]] =
      AwsError.unwrapOptionField("connectorIDs", connectorIDs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ListConnectorsRequestFilters
  ) extends zio.aws.mgn.model.ListConnectorsRequestFilters.ReadOnly {
    override val connectorIDs: Optional[List[ConnectorID]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorIDs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mgn.model.primitives.ConnectorID(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ListConnectorsRequestFilters
  ): zio.aws.mgn.model.ListConnectorsRequestFilters.ReadOnly = new Wrapper(impl)
}
