package zio.aws.mgn.model
import zio.aws.mgn.model.primitives.{PaginationToken, MaxResultsType}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListConnectorsRequest(
    filters: Optional[zio.aws.mgn.model.ListConnectorsRequestFilters] =
      Optional.Absent,
    maxResults: Optional[MaxResultsType] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ListConnectorsRequest = {
    import ListConnectorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ListConnectorsRequest
      .builder()
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResultsType.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ListConnectorsRequest.ReadOnly =
    zio.aws.mgn.model.ListConnectorsRequest.wrap(buildAwsValue())
}
object ListConnectorsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ListConnectorsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ListConnectorsRequest =
      zio.aws.mgn.model.ListConnectorsRequest(
        filters.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filters
        : Optional[zio.aws.mgn.model.ListConnectorsRequestFilters.ReadOnly]
    def maxResults: Optional[MaxResultsType]
    def nextToken: Optional[PaginationToken]
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.ListConnectorsRequestFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResultsType] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ListConnectorsRequest
  ) extends zio.aws.mgn.model.ListConnectorsRequest.ReadOnly {
    override val filters
        : Optional[zio.aws.mgn.model.ListConnectorsRequestFilters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          zio.aws.mgn.model.ListConnectorsRequestFilters.wrap(value)
        )
    override val maxResults: Optional[MaxResultsType] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.mgn.model.primitives.MaxResultsType(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.mgn.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ListConnectorsRequest
  ): zio.aws.mgn.model.ListConnectorsRequest.ReadOnly = new Wrapper(impl)
}
