package zio.aws.mgn.model
import scala.jdk.CollectionConverters._
sealed trait LifeCycleState {
  def unwrap: software.amazon.awssdk.services.mgn.model.LifeCycleState
}
object LifeCycleState {
  def wrap(
      value: software.amazon.awssdk.services.mgn.model.LifeCycleState
  ): zio.aws.mgn.model.LifeCycleState = value match {
    case software.amazon.awssdk.services.mgn.model.LifeCycleState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mgn.model.LifeCycleState.STOPPED =>
      val r = STOPPED
      r
    case software.amazon.awssdk.services.mgn.model.LifeCycleState.NOT_READY =>
      val r = NOT_READY
      r
    case software.amazon.awssdk.services.mgn.model.LifeCycleState.READY_FOR_TEST =>
      val r = READY_FOR_TEST
      r
    case software.amazon.awssdk.services.mgn.model.LifeCycleState.TESTING =>
      val r = TESTING
      r
    case software.amazon.awssdk.services.mgn.model.LifeCycleState.READY_FOR_CUTOVER =>
      val r = READY_FOR_CUTOVER
      r
    case software.amazon.awssdk.services.mgn.model.LifeCycleState.CUTTING_OVER =>
      val r = CUTTING_OVER
      r
    case software.amazon.awssdk.services.mgn.model.LifeCycleState.CUTOVER =>
      val r = CUTOVER
      r
    case software.amazon.awssdk.services.mgn.model.LifeCycleState.DISCONNECTED =>
      val r = DISCONNECTED
      r
    case software.amazon.awssdk.services.mgn.model.LifeCycleState.DISCOVERED =>
      val r = DISCOVERED
      r
    case software.amazon.awssdk.services.mgn.model.LifeCycleState.PENDING_INSTALLATION =>
      val r = PENDING_INSTALLATION
      r
  }
  case object unknownToSdkVersion extends zio.aws.mgn.model.LifeCycleState {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.LifeCycleState =
      software.amazon.awssdk.services.mgn.model.LifeCycleState.UNKNOWN_TO_SDK_VERSION
  }
  case object STOPPED extends zio.aws.mgn.model.LifeCycleState {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.LifeCycleState =
      software.amazon.awssdk.services.mgn.model.LifeCycleState.STOPPED
  }
  case object NOT_READY extends zio.aws.mgn.model.LifeCycleState {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.LifeCycleState =
      software.amazon.awssdk.services.mgn.model.LifeCycleState.NOT_READY
  }
  case object READY_FOR_TEST extends zio.aws.mgn.model.LifeCycleState {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.LifeCycleState =
      software.amazon.awssdk.services.mgn.model.LifeCycleState.READY_FOR_TEST
  }
  case object TESTING extends zio.aws.mgn.model.LifeCycleState {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.LifeCycleState =
      software.amazon.awssdk.services.mgn.model.LifeCycleState.TESTING
  }
  case object READY_FOR_CUTOVER extends zio.aws.mgn.model.LifeCycleState {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.LifeCycleState =
      software.amazon.awssdk.services.mgn.model.LifeCycleState.READY_FOR_CUTOVER
  }
  case object CUTTING_OVER extends zio.aws.mgn.model.LifeCycleState {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.LifeCycleState =
      software.amazon.awssdk.services.mgn.model.LifeCycleState.CUTTING_OVER
  }
  case object CUTOVER extends zio.aws.mgn.model.LifeCycleState {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.LifeCycleState =
      software.amazon.awssdk.services.mgn.model.LifeCycleState.CUTOVER
  }
  case object DISCONNECTED extends zio.aws.mgn.model.LifeCycleState {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.LifeCycleState =
      software.amazon.awssdk.services.mgn.model.LifeCycleState.DISCONNECTED
  }
  case object DISCOVERED extends zio.aws.mgn.model.LifeCycleState {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.LifeCycleState =
      software.amazon.awssdk.services.mgn.model.LifeCycleState.DISCOVERED
  }
  case object PENDING_INSTALLATION extends zio.aws.mgn.model.LifeCycleState {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.LifeCycleState =
      software.amazon.awssdk.services.mgn.model.LifeCycleState.PENDING_INSTALLATION
  }
}
