package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.ISO8601DatetimeString
import scala.jdk.CollectionConverters._
final case class LifeCycleLastTestReverted(
    apiCallDateTime: Optional[ISO8601DatetimeString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.LifeCycleLastTestReverted = {
    import LifeCycleLastTestReverted.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.LifeCycleLastTestReverted
      .builder()
      .optionallyWith(
        apiCallDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.apiCallDateTime)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.LifeCycleLastTestReverted.ReadOnly =
    zio.aws.mgn.model.LifeCycleLastTestReverted.wrap(buildAwsValue())
}
object LifeCycleLastTestReverted {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.LifeCycleLastTestReverted
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.LifeCycleLastTestReverted =
      zio.aws.mgn.model
        .LifeCycleLastTestReverted(apiCallDateTime.map(value => value))
    def apiCallDateTime: Optional[ISO8601DatetimeString]
    def getApiCallDateTime: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("apiCallDateTime", apiCallDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.LifeCycleLastTestReverted
  ) extends zio.aws.mgn.model.LifeCycleLastTestReverted.ReadOnly {
    override val apiCallDateTime: Optional[ISO8601DatetimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiCallDateTime())
        .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.LifeCycleLastTestReverted
  ): zio.aws.mgn.model.LifeCycleLastTestReverted.ReadOnly = new Wrapper(impl)
}
