package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.ISO8601DatetimeString
import scala.jdk.CollectionConverters._
final case class LifeCycleLastCutoverFinalized(
    apiCallDateTime: Optional[ISO8601DatetimeString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.LifeCycleLastCutoverFinalized = {
    import LifeCycleLastCutoverFinalized.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.LifeCycleLastCutoverFinalized
      .builder()
      .optionallyWith(
        apiCallDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.apiCallDateTime)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.LifeCycleLastCutoverFinalized.ReadOnly =
    zio.aws.mgn.model.LifeCycleLastCutoverFinalized.wrap(buildAwsValue())
}
object LifeCycleLastCutoverFinalized {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.LifeCycleLastCutoverFinalized
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.LifeCycleLastCutoverFinalized =
      zio.aws.mgn.model
        .LifeCycleLastCutoverFinalized(apiCallDateTime.map(value => value))
    def apiCallDateTime: Optional[ISO8601DatetimeString]
    def getApiCallDateTime: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("apiCallDateTime", apiCallDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.LifeCycleLastCutoverFinalized
  ) extends zio.aws.mgn.model.LifeCycleLastCutoverFinalized.ReadOnly {
    override val apiCallDateTime: Optional[ISO8601DatetimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiCallDateTime())
        .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.LifeCycleLastCutoverFinalized
  ): zio.aws.mgn.model.LifeCycleLastCutoverFinalized.ReadOnly = new Wrapper(
    impl
  )
}
