package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{Throughput, Iops}
import scala.jdk.CollectionConverters._
final case class LaunchTemplateDiskConf(
    iops: Optional[Iops] = Optional.Absent,
    throughput: Optional[Throughput] = Optional.Absent,
    volumeType: Optional[zio.aws.mgn.model.VolumeType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.LaunchTemplateDiskConf = {
    import LaunchTemplateDiskConf.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.LaunchTemplateDiskConf
      .builder()
      .optionallyWith(iops.map(value => Iops.unwrap(value): java.lang.Long))(
        _.iops
      )
      .optionallyWith(
        throughput.map(value => Throughput.unwrap(value): java.lang.Long)
      )(_.throughput)
      .optionallyWith(volumeType.map(value => value.unwrap))(_.volumeType)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.LaunchTemplateDiskConf.ReadOnly =
    zio.aws.mgn.model.LaunchTemplateDiskConf.wrap(buildAwsValue())
}
object LaunchTemplateDiskConf {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.LaunchTemplateDiskConf
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.LaunchTemplateDiskConf =
      zio.aws.mgn.model.LaunchTemplateDiskConf(
        iops.map(value => value),
        throughput.map(value => value),
        volumeType.map(value => value)
      )
    def iops: Optional[Iops]
    def throughput: Optional[Throughput]
    def volumeType: Optional[zio.aws.mgn.model.VolumeType]
    def getIops: ZIO[Any, AwsError, Iops] =
      AwsError.unwrapOptionField("iops", iops)
    def getThroughput: ZIO[Any, AwsError, Throughput] =
      AwsError.unwrapOptionField("throughput", throughput)
    def getVolumeType: ZIO[Any, AwsError, zio.aws.mgn.model.VolumeType] =
      AwsError.unwrapOptionField("volumeType", volumeType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.LaunchTemplateDiskConf
  ) extends zio.aws.mgn.model.LaunchTemplateDiskConf.ReadOnly {
    override val iops: Optional[Iops] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => zio.aws.mgn.model.primitives.Iops(value))
    override val throughput: Optional[Throughput] = zio.aws.core.internal
      .optionalFromNullable(impl.throughput())
      .map(value => zio.aws.mgn.model.primitives.Throughput(value))
    override val volumeType: Optional[zio.aws.mgn.model.VolumeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeType())
        .map(value => zio.aws.mgn.model.VolumeType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.LaunchTemplateDiskConf
  ): zio.aws.mgn.model.LaunchTemplateDiskConf.ReadOnly = new Wrapper(impl)
}
