package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{SourceServerID, AccountID}
import scala.jdk.CollectionConverters._
final case class DisconnectFromServiceRequest(
    accountID: Optional[AccountID] = Optional.Absent,
    sourceServerID: SourceServerID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DisconnectFromServiceRequest = {
    import DisconnectFromServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DisconnectFromServiceRequest
      .builder()
      .optionallyWith(
        accountID.map(value => AccountID.unwrap(value): java.lang.String)
      )(_.accountID)
      .sourceServerID(SourceServerID.unwrap(sourceServerID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DisconnectFromServiceRequest.ReadOnly =
    zio.aws.mgn.model.DisconnectFromServiceRequest.wrap(buildAwsValue())
}
object DisconnectFromServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DisconnectFromServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DisconnectFromServiceRequest =
      zio.aws.mgn.model.DisconnectFromServiceRequest(
        accountID.map(value => value),
        sourceServerID
      )
    def accountID: Optional[AccountID]
    def sourceServerID: SourceServerID
    def getAccountID: ZIO[Any, AwsError, AccountID] =
      AwsError.unwrapOptionField("accountID", accountID)
    def getSourceServerID: ZIO[Any, Nothing, SourceServerID] =
      ZIO.succeed(sourceServerID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DisconnectFromServiceRequest
  ) extends zio.aws.mgn.model.DisconnectFromServiceRequest.ReadOnly {
    override val accountID: Optional[AccountID] = zio.aws.core.internal
      .optionalFromNullable(impl.accountID())
      .map(value => zio.aws.mgn.model.primitives.AccountID(value))
    override val sourceServerID: SourceServerID =
      zio.aws.mgn.model.primitives.SourceServerID(impl.sourceServerID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DisconnectFromServiceRequest
  ): zio.aws.mgn.model.DisconnectFromServiceRequest.ReadOnly = new Wrapper(impl)
}
