package zio.aws.mgn.model
import zio.aws.mgn.model.primitives.{PaginationToken, MaxResultsType, AccountID}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeSourceServersRequest(
    accountID: Optional[AccountID] = Optional.Absent,
    filters: Optional[zio.aws.mgn.model.DescribeSourceServersRequestFilters] =
      Optional.Absent,
    maxResults: Optional[MaxResultsType] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequest = {
    import DescribeSourceServersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequest
      .builder()
      .optionallyWith(
        accountID.map(value => AccountID.unwrap(value): java.lang.String)
      )(_.accountID)
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResultsType.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DescribeSourceServersRequest.ReadOnly =
    zio.aws.mgn.model.DescribeSourceServersRequest.wrap(buildAwsValue())
}
object DescribeSourceServersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DescribeSourceServersRequest =
      zio.aws.mgn.model.DescribeSourceServersRequest(
        accountID.map(value => value),
        filters.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def accountID: Optional[AccountID]
    def filters: Optional[
      zio.aws.mgn.model.DescribeSourceServersRequestFilters.ReadOnly
    ]
    def maxResults: Optional[MaxResultsType]
    def nextToken: Optional[PaginationToken]
    def getAccountID: ZIO[Any, AwsError, AccountID] =
      AwsError.unwrapOptionField("accountID", accountID)
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.DescribeSourceServersRequestFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResultsType] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequest
  ) extends zio.aws.mgn.model.DescribeSourceServersRequest.ReadOnly {
    override val accountID: Optional[AccountID] = zio.aws.core.internal
      .optionalFromNullable(impl.accountID())
      .map(value => zio.aws.mgn.model.primitives.AccountID(value))
    override val filters: Optional[
      zio.aws.mgn.model.DescribeSourceServersRequestFilters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        zio.aws.mgn.model.DescribeSourceServersRequestFilters.wrap(value)
      )
    override val maxResults: Optional[MaxResultsType] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.mgn.model.primitives.MaxResultsType(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.mgn.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequest
  ): zio.aws.mgn.model.DescribeSourceServersRequest.ReadOnly = new Wrapper(impl)
}
