package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mgn.model.primitives.ConnectorID
import scala.jdk.CollectionConverters._
final case class DeleteConnectorRequest(connectorID: ConnectorID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DeleteConnectorRequest = {
    import DeleteConnectorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DeleteConnectorRequest
      .builder()
      .connectorID(ConnectorID.unwrap(connectorID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DeleteConnectorRequest.ReadOnly =
    zio.aws.mgn.model.DeleteConnectorRequest.wrap(buildAwsValue())
}
object DeleteConnectorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DeleteConnectorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DeleteConnectorRequest =
      zio.aws.mgn.model.DeleteConnectorRequest(connectorID)
    def connectorID: ConnectorID
    def getConnectorID: ZIO[Any, Nothing, ConnectorID] =
      ZIO.succeed(connectorID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DeleteConnectorRequest
  ) extends zio.aws.mgn.model.DeleteConnectorRequest.ReadOnly {
    override val connectorID: ConnectorID =
      zio.aws.mgn.model.primitives.ConnectorID(impl.connectorID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DeleteConnectorRequest
  ): zio.aws.mgn.model.DeleteConnectorRequest.ReadOnly = new Wrapper(impl)
}
