package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{S3BucketName, CloudWatchLogGroupName}
import scala.jdk.CollectionConverters._
final case class ConnectorSsmCommandConfig(
    cloudWatchLogGroupName: Optional[CloudWatchLogGroupName] = Optional.Absent,
    cloudWatchOutputEnabled: Boolean,
    outputS3BucketName: Optional[S3BucketName] = Optional.Absent,
    s3OutputEnabled: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ConnectorSsmCommandConfig = {
    import ConnectorSsmCommandConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ConnectorSsmCommandConfig
      .builder()
      .optionallyWith(
        cloudWatchLogGroupName.map(value =>
          CloudWatchLogGroupName.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogGroupName)
      .cloudWatchOutputEnabled(cloudWatchOutputEnabled: java.lang.Boolean)
      .optionallyWith(
        outputS3BucketName.map(value =>
          S3BucketName.unwrap(value): java.lang.String
        )
      )(_.outputS3BucketName)
      .s3OutputEnabled(s3OutputEnabled: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ConnectorSsmCommandConfig.ReadOnly =
    zio.aws.mgn.model.ConnectorSsmCommandConfig.wrap(buildAwsValue())
}
object ConnectorSsmCommandConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ConnectorSsmCommandConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ConnectorSsmCommandConfig =
      zio.aws.mgn.model.ConnectorSsmCommandConfig(
        cloudWatchLogGroupName.map(value => value),
        cloudWatchOutputEnabled,
        outputS3BucketName.map(value => value),
        s3OutputEnabled
      )
    def cloudWatchLogGroupName: Optional[CloudWatchLogGroupName]
    def cloudWatchOutputEnabled: Boolean
    def outputS3BucketName: Optional[S3BucketName]
    def s3OutputEnabled: Boolean
    def getCloudWatchLogGroupName: ZIO[Any, AwsError, CloudWatchLogGroupName] =
      AwsError.unwrapOptionField(
        "cloudWatchLogGroupName",
        cloudWatchLogGroupName
      )
    def getCloudWatchOutputEnabled: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(cloudWatchOutputEnabled)
    def getOutputS3BucketName: ZIO[Any, AwsError, S3BucketName] =
      AwsError.unwrapOptionField("outputS3BucketName", outputS3BucketName)
    def getS3OutputEnabled: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(s3OutputEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ConnectorSsmCommandConfig
  ) extends zio.aws.mgn.model.ConnectorSsmCommandConfig.ReadOnly {
    override val cloudWatchLogGroupName: Optional[CloudWatchLogGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLogGroupName())
        .map(value =>
          zio.aws.mgn.model.primitives.CloudWatchLogGroupName(value)
        )
    override val cloudWatchOutputEnabled: Boolean =
      impl.cloudWatchOutputEnabled(): Boolean
    override val outputS3BucketName: Optional[S3BucketName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputS3BucketName())
        .map(value => zio.aws.mgn.model.primitives.S3BucketName(value))
    override val s3OutputEnabled: Boolean = impl.s3OutputEnabled(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ConnectorSsmCommandConfig
  ): zio.aws.mgn.model.ConnectorSsmCommandConfig.ReadOnly = new Wrapper(impl)
}
