package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{SourceServerID, AccountID}
import scala.jdk.CollectionConverters._
final case class ChangeServerLifeCycleStateRequest(
    accountID: Optional[AccountID] = Optional.Absent,
    lifeCycle: zio.aws.mgn.model.ChangeServerLifeCycleStateSourceServerLifecycle,
    sourceServerID: SourceServerID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ChangeServerLifeCycleStateRequest = {
    import ChangeServerLifeCycleStateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ChangeServerLifeCycleStateRequest
      .builder()
      .optionallyWith(
        accountID.map(value => AccountID.unwrap(value): java.lang.String)
      )(_.accountID)
      .lifeCycle(lifeCycle.buildAwsValue())
      .sourceServerID(SourceServerID.unwrap(sourceServerID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ChangeServerLifeCycleStateRequest.ReadOnly =
    zio.aws.mgn.model.ChangeServerLifeCycleStateRequest.wrap(buildAwsValue())
}
object ChangeServerLifeCycleStateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ChangeServerLifeCycleStateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ChangeServerLifeCycleStateRequest =
      zio.aws.mgn.model.ChangeServerLifeCycleStateRequest(
        accountID.map(value => value),
        lifeCycle.asEditable,
        sourceServerID
      )
    def accountID: Optional[AccountID]
    def lifeCycle
        : zio.aws.mgn.model.ChangeServerLifeCycleStateSourceServerLifecycle.ReadOnly
    def sourceServerID: SourceServerID
    def getAccountID: ZIO[Any, AwsError, AccountID] =
      AwsError.unwrapOptionField("accountID", accountID)
    def getLifeCycle: ZIO[
      Any,
      Nothing,
      zio.aws.mgn.model.ChangeServerLifeCycleStateSourceServerLifecycle.ReadOnly
    ] = ZIO.succeed(lifeCycle)
    def getSourceServerID: ZIO[Any, Nothing, SourceServerID] =
      ZIO.succeed(sourceServerID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ChangeServerLifeCycleStateRequest
  ) extends zio.aws.mgn.model.ChangeServerLifeCycleStateRequest.ReadOnly {
    override val accountID: Optional[AccountID] = zio.aws.core.internal
      .optionalFromNullable(impl.accountID())
      .map(value => zio.aws.mgn.model.primitives.AccountID(value))
    override val lifeCycle
        : zio.aws.mgn.model.ChangeServerLifeCycleStateSourceServerLifecycle.ReadOnly =
      zio.aws.mgn.model.ChangeServerLifeCycleStateSourceServerLifecycle
        .wrap(impl.lifeCycle())
    override val sourceServerID: SourceServerID =
      zio.aws.mgn.model.primitives.SourceServerID(impl.sourceServerID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ChangeServerLifeCycleStateRequest
  ): zio.aws.mgn.model.ChangeServerLifeCycleStateRequest.ReadOnly = new Wrapper(
    impl
  )
}
