package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mgn.model.primitives.WaveID
import scala.jdk.CollectionConverters._
final case class UnarchiveWaveRequest(waveID: WaveID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.UnarchiveWaveRequest = {
    import UnarchiveWaveRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.UnarchiveWaveRequest
      .builder()
      .waveID(WaveID.unwrap(waveID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.UnarchiveWaveRequest.ReadOnly =
    zio.aws.mgn.model.UnarchiveWaveRequest.wrap(buildAwsValue())
}
object UnarchiveWaveRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.UnarchiveWaveRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.UnarchiveWaveRequest =
      zio.aws.mgn.model.UnarchiveWaveRequest(waveID)
    def waveID: WaveID
    def getWaveID: ZIO[Any, Nothing, WaveID] = ZIO.succeed(waveID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.UnarchiveWaveRequest
  ) extends zio.aws.mgn.model.UnarchiveWaveRequest.ReadOnly {
    override val waveID: WaveID =
      zio.aws.mgn.model.primitives.WaveID(impl.waveID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.UnarchiveWaveRequest
  ): zio.aws.mgn.model.UnarchiveWaveRequest.ReadOnly = new Wrapper(impl)
}
