package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mgn.model.primitives.{LaunchConfigurationTemplateID, ActionID}
import scala.jdk.CollectionConverters._
final case class RemoveTemplateActionRequest(
    actionID: ActionID,
    launchConfigurationTemplateID: LaunchConfigurationTemplateID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.RemoveTemplateActionRequest = {
    import RemoveTemplateActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.RemoveTemplateActionRequest
      .builder()
      .actionID(ActionID.unwrap(actionID): java.lang.String)
      .launchConfigurationTemplateID(
        LaunchConfigurationTemplateID.unwrap(
          launchConfigurationTemplateID
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.RemoveTemplateActionRequest.ReadOnly =
    zio.aws.mgn.model.RemoveTemplateActionRequest.wrap(buildAwsValue())
}
object RemoveTemplateActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.RemoveTemplateActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.RemoveTemplateActionRequest =
      zio.aws.mgn.model
        .RemoveTemplateActionRequest(actionID, launchConfigurationTemplateID)
    def actionID: ActionID
    def launchConfigurationTemplateID: LaunchConfigurationTemplateID
    def getActionID: ZIO[Any, Nothing, ActionID] = ZIO.succeed(actionID)
    def getLaunchConfigurationTemplateID
        : ZIO[Any, Nothing, LaunchConfigurationTemplateID] =
      ZIO.succeed(launchConfigurationTemplateID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.RemoveTemplateActionRequest
  ) extends zio.aws.mgn.model.RemoveTemplateActionRequest.ReadOnly {
    override val actionID: ActionID =
      zio.aws.mgn.model.primitives.ActionID(impl.actionID())
    override val launchConfigurationTemplateID: LaunchConfigurationTemplateID =
      zio.aws.mgn.model.primitives
        .LaunchConfigurationTemplateID(impl.launchConfigurationTemplateID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.RemoveTemplateActionRequest
  ): zio.aws.mgn.model.RemoveTemplateActionRequest.ReadOnly = new Wrapper(impl)
}
