package zio.aws.mgn.model
import zio.aws.mgn.model.primitives.{
  SourceServerID,
  PaginationToken,
  MaxResultsType
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListSourceServerActionsRequest(
    filters: Optional[zio.aws.mgn.model.SourceServerActionsRequestFilters] =
      Optional.Absent,
    maxResults: Optional[MaxResultsType] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    sourceServerID: SourceServerID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ListSourceServerActionsRequest = {
    import ListSourceServerActionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ListSourceServerActionsRequest
      .builder()
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResultsType.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .sourceServerID(SourceServerID.unwrap(sourceServerID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ListSourceServerActionsRequest.ReadOnly =
    zio.aws.mgn.model.ListSourceServerActionsRequest.wrap(buildAwsValue())
}
object ListSourceServerActionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ListSourceServerActionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ListSourceServerActionsRequest =
      zio.aws.mgn.model.ListSourceServerActionsRequest(
        filters.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value),
        sourceServerID
      )
    def filters
        : Optional[zio.aws.mgn.model.SourceServerActionsRequestFilters.ReadOnly]
    def maxResults: Optional[MaxResultsType]
    def nextToken: Optional[PaginationToken]
    def sourceServerID: SourceServerID
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.SourceServerActionsRequestFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResultsType] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSourceServerID: ZIO[Any, Nothing, SourceServerID] =
      ZIO.succeed(sourceServerID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ListSourceServerActionsRequest
  ) extends zio.aws.mgn.model.ListSourceServerActionsRequest.ReadOnly {
    override val filters: Optional[
      zio.aws.mgn.model.SourceServerActionsRequestFilters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        zio.aws.mgn.model.SourceServerActionsRequestFilters.wrap(value)
      )
    override val maxResults: Optional[MaxResultsType] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.mgn.model.primitives.MaxResultsType(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.mgn.model.primitives.PaginationToken(value))
    override val sourceServerID: SourceServerID =
      zio.aws.mgn.model.primitives.SourceServerID(impl.sourceServerID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ListSourceServerActionsRequest
  ): zio.aws.mgn.model.ListSourceServerActionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
