package zio.aws.mgn.model
import zio.aws.mgn.model.primitives.{PaginationToken, MaxResultsType, ImportID}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListImportErrorsRequest(
    importID: ImportID,
    maxResults: Optional[MaxResultsType] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ListImportErrorsRequest = {
    import ListImportErrorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ListImportErrorsRequest
      .builder()
      .importID(ImportID.unwrap(importID): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResultsType.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ListImportErrorsRequest.ReadOnly =
    zio.aws.mgn.model.ListImportErrorsRequest.wrap(buildAwsValue())
}
object ListImportErrorsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ListImportErrorsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ListImportErrorsRequest =
      zio.aws.mgn.model.ListImportErrorsRequest(
        importID,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def importID: ImportID
    def maxResults: Optional[MaxResultsType]
    def nextToken: Optional[PaginationToken]
    def getImportID: ZIO[Any, Nothing, ImportID] = ZIO.succeed(importID)
    def getMaxResults: ZIO[Any, AwsError, MaxResultsType] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ListImportErrorsRequest
  ) extends zio.aws.mgn.model.ListImportErrorsRequest.ReadOnly {
    override val importID: ImportID =
      zio.aws.mgn.model.primitives.ImportID(impl.importID())
    override val maxResults: Optional[MaxResultsType] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.mgn.model.primitives.MaxResultsType(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.mgn.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ListImportErrorsRequest
  ): zio.aws.mgn.model.ListImportErrorsRequest.ReadOnly = new Wrapper(impl)
}
