package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.PositiveInteger
import scala.jdk.CollectionConverters._
final case class ImportTaskSummaryApplications(
    createdCount: Optional[PositiveInteger] = Optional.Absent,
    modifiedCount: Optional[PositiveInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ImportTaskSummaryApplications = {
    import ImportTaskSummaryApplications.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ImportTaskSummaryApplications
      .builder()
      .optionallyWith(
        createdCount.map(value => PositiveInteger.unwrap(value): java.lang.Long)
      )(_.createdCount)
      .optionallyWith(
        modifiedCount.map(value =>
          PositiveInteger.unwrap(value): java.lang.Long
        )
      )(_.modifiedCount)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ImportTaskSummaryApplications.ReadOnly =
    zio.aws.mgn.model.ImportTaskSummaryApplications.wrap(buildAwsValue())
}
object ImportTaskSummaryApplications {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ImportTaskSummaryApplications
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ImportTaskSummaryApplications =
      zio.aws.mgn.model.ImportTaskSummaryApplications(
        createdCount.map(value => value),
        modifiedCount.map(value => value)
      )
    def createdCount: Optional[PositiveInteger]
    def modifiedCount: Optional[PositiveInteger]
    def getCreatedCount: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("createdCount", createdCount)
    def getModifiedCount: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("modifiedCount", modifiedCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ImportTaskSummaryApplications
  ) extends zio.aws.mgn.model.ImportTaskSummaryApplications.ReadOnly {
    override val createdCount: Optional[PositiveInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.createdCount())
      .map(value => zio.aws.mgn.model.primitives.PositiveInteger(value))
    override val modifiedCount: Optional[PositiveInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modifiedCount())
        .map(value => zio.aws.mgn.model.primitives.PositiveInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ImportTaskSummaryApplications
  ): zio.aws.mgn.model.ImportTaskSummaryApplications.ReadOnly = new Wrapper(
    impl
  )
}
