package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mgn.model.primitives.SourceServerID
import scala.jdk.CollectionConverters._
final case class GetReplicationConfigurationRequest(
    sourceServerID: SourceServerID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.GetReplicationConfigurationRequest = {
    import GetReplicationConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.GetReplicationConfigurationRequest
      .builder()
      .sourceServerID(SourceServerID.unwrap(sourceServerID): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.mgn.model.GetReplicationConfigurationRequest.ReadOnly =
    zio.aws.mgn.model.GetReplicationConfigurationRequest.wrap(buildAwsValue())
}
object GetReplicationConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.GetReplicationConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.GetReplicationConfigurationRequest =
      zio.aws.mgn.model.GetReplicationConfigurationRequest(sourceServerID)
    def sourceServerID: SourceServerID
    def getSourceServerID: ZIO[Any, Nothing, SourceServerID] =
      ZIO.succeed(sourceServerID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.GetReplicationConfigurationRequest
  ) extends zio.aws.mgn.model.GetReplicationConfigurationRequest.ReadOnly {
    override val sourceServerID: SourceServerID =
      zio.aws.mgn.model.primitives.SourceServerID(impl.sourceServerID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.GetReplicationConfigurationRequest
  ): zio.aws.mgn.model.GetReplicationConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
