package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.PositiveInteger
import scala.jdk.CollectionConverters._
final case class ExportTaskSummary(
    applicationsCount: Optional[PositiveInteger] = Optional.Absent,
    serversCount: Optional[PositiveInteger] = Optional.Absent,
    wavesCount: Optional[PositiveInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ExportTaskSummary = {
    import ExportTaskSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ExportTaskSummary
      .builder()
      .optionallyWith(
        applicationsCount.map(value =>
          PositiveInteger.unwrap(value): java.lang.Long
        )
      )(_.applicationsCount)
      .optionallyWith(
        serversCount.map(value => PositiveInteger.unwrap(value): java.lang.Long)
      )(_.serversCount)
      .optionallyWith(
        wavesCount.map(value => PositiveInteger.unwrap(value): java.lang.Long)
      )(_.wavesCount)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ExportTaskSummary.ReadOnly =
    zio.aws.mgn.model.ExportTaskSummary.wrap(buildAwsValue())
}
object ExportTaskSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ExportTaskSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ExportTaskSummary =
      zio.aws.mgn.model.ExportTaskSummary(
        applicationsCount.map(value => value),
        serversCount.map(value => value),
        wavesCount.map(value => value)
      )
    def applicationsCount: Optional[PositiveInteger]
    def serversCount: Optional[PositiveInteger]
    def wavesCount: Optional[PositiveInteger]
    def getApplicationsCount: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("applicationsCount", applicationsCount)
    def getServersCount: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("serversCount", serversCount)
    def getWavesCount: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("wavesCount", wavesCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ExportTaskSummary
  ) extends zio.aws.mgn.model.ExportTaskSummary.ReadOnly {
    override val applicationsCount: Optional[PositiveInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationsCount())
        .map(value => zio.aws.mgn.model.primitives.PositiveInteger(value))
    override val serversCount: Optional[PositiveInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.serversCount())
      .map(value => zio.aws.mgn.model.primitives.PositiveInteger(value))
    override val wavesCount: Optional[PositiveInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.wavesCount())
      .map(value => zio.aws.mgn.model.primitives.PositiveInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ExportTaskSummary
  ): zio.aws.mgn.model.ExportTaskSummary.ReadOnly = new Wrapper(impl)
}
