package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{
  TagValue,
  TagKey,
  WaveName,
  WaveDescription
}
import scala.jdk.CollectionConverters._
final case class CreateWaveRequest(
    description: Optional[WaveDescription] = Optional.Absent,
    name: WaveName,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.CreateWaveRequest = {
    import CreateWaveRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.CreateWaveRequest
      .builder()
      .optionallyWith(
        description.map(value =>
          WaveDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .name(WaveName.unwrap(name): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.CreateWaveRequest.ReadOnly =
    zio.aws.mgn.model.CreateWaveRequest.wrap(buildAwsValue())
}
object CreateWaveRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.CreateWaveRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.CreateWaveRequest =
      zio.aws.mgn.model.CreateWaveRequest(
        description.map(value => value),
        name,
        tags.map(value => value)
      )
    def description: Optional[WaveDescription]
    def name: WaveName
    def tags: Optional[Map[TagKey, TagValue]]
    def getDescription: ZIO[Any, AwsError, WaveDescription] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, WaveName] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.CreateWaveRequest
  ) extends zio.aws.mgn.model.CreateWaveRequest.ReadOnly {
    override val description: Optional[WaveDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.mgn.model.primitives.WaveDescription(value))
    override val name: WaveName =
      zio.aws.mgn.model.primitives.WaveName(impl.name())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mgn.model.primitives
              .TagKey(key) -> zio.aws.mgn.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.CreateWaveRequest
  ): zio.aws.mgn.model.CreateWaveRequest.ReadOnly = new Wrapper(impl)
}
