package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mgn.model.primitives.{SourceServerID, ApplicationID}
import scala.jdk.CollectionConverters._
final case class AssociateSourceServersRequest(
    applicationID: ApplicationID,
    sourceServerIDs: Iterable[SourceServerID]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.AssociateSourceServersRequest = {
    import AssociateSourceServersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.AssociateSourceServersRequest
      .builder()
      .applicationID(ApplicationID.unwrap(applicationID): java.lang.String)
      .sourceServerIDs(sourceServerIDs.map { item =>
        SourceServerID.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.AssociateSourceServersRequest.ReadOnly =
    zio.aws.mgn.model.AssociateSourceServersRequest.wrap(buildAwsValue())
}
object AssociateSourceServersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.AssociateSourceServersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.AssociateSourceServersRequest =
      zio.aws.mgn.model
        .AssociateSourceServersRequest(applicationID, sourceServerIDs)
    def applicationID: ApplicationID
    def sourceServerIDs: List[SourceServerID]
    def getApplicationID: ZIO[Any, Nothing, ApplicationID] =
      ZIO.succeed(applicationID)
    def getSourceServerIDs: ZIO[Any, Nothing, List[SourceServerID]] =
      ZIO.succeed(sourceServerIDs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.AssociateSourceServersRequest
  ) extends zio.aws.mgn.model.AssociateSourceServersRequest.ReadOnly {
    override val applicationID: ApplicationID =
      zio.aws.mgn.model.primitives.ApplicationID(impl.applicationID())
    override val sourceServerIDs: List[SourceServerID] = impl
      .sourceServerIDs()
      .asScala
      .map { item =>
        zio.aws.mgn.model.primitives.SourceServerID(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.AssociateSourceServersRequest
  ): zio.aws.mgn.model.AssociateSourceServersRequest.ReadOnly = new Wrapper(
    impl
  )
}
