package zio.aws.mgn.model
import scala.jdk.CollectionConverters._
sealed trait ApplicationProgressStatus {
  def unwrap
      : software.amazon.awssdk.services.mgn.model.ApplicationProgressStatus
}
object ApplicationProgressStatus {
  def wrap(
      value: software.amazon.awssdk.services.mgn.model.ApplicationProgressStatus
  ): zio.aws.mgn.model.ApplicationProgressStatus = value match {
    case software.amazon.awssdk.services.mgn.model.ApplicationProgressStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mgn.model.ApplicationProgressStatus.NOT_STARTED =>
      val r = NOT_STARTED
      r
    case software.amazon.awssdk.services.mgn.model.ApplicationProgressStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.mgn.model.ApplicationProgressStatus.COMPLETED =>
      val r = COMPLETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mgn.model.ApplicationProgressStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ApplicationProgressStatus =
      software.amazon.awssdk.services.mgn.model.ApplicationProgressStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object NOT_STARTED extends zio.aws.mgn.model.ApplicationProgressStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ApplicationProgressStatus =
      software.amazon.awssdk.services.mgn.model.ApplicationProgressStatus.NOT_STARTED
  }
  case object IN_PROGRESS extends zio.aws.mgn.model.ApplicationProgressStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ApplicationProgressStatus =
      software.amazon.awssdk.services.mgn.model.ApplicationProgressStatus.IN_PROGRESS
  }
  case object COMPLETED extends zio.aws.mgn.model.ApplicationProgressStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ApplicationProgressStatus =
      software.amazon.awssdk.services.mgn.model.ApplicationProgressStatus.COMPLETED
  }
}
