package zio.aws.mgn.model
import scala.jdk.CollectionConverters._
sealed trait ApplicationHealthStatus {
  def unwrap: software.amazon.awssdk.services.mgn.model.ApplicationHealthStatus
}
object ApplicationHealthStatus {
  def wrap(
      value: software.amazon.awssdk.services.mgn.model.ApplicationHealthStatus
  ): zio.aws.mgn.model.ApplicationHealthStatus = value match {
    case software.amazon.awssdk.services.mgn.model.ApplicationHealthStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mgn.model.ApplicationHealthStatus.HEALTHY =>
      val r = HEALTHY
      r
    case software.amazon.awssdk.services.mgn.model.ApplicationHealthStatus.LAGGING =>
      val r = LAGGING
      r
    case software.amazon.awssdk.services.mgn.model.ApplicationHealthStatus.ERROR =>
      val r = ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mgn.model.ApplicationHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ApplicationHealthStatus =
      software.amazon.awssdk.services.mgn.model.ApplicationHealthStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object HEALTHY extends zio.aws.mgn.model.ApplicationHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ApplicationHealthStatus =
      software.amazon.awssdk.services.mgn.model.ApplicationHealthStatus.HEALTHY
  }
  case object LAGGING extends zio.aws.mgn.model.ApplicationHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ApplicationHealthStatus =
      software.amazon.awssdk.services.mgn.model.ApplicationHealthStatus.LAGGING
  }
  case object ERROR extends zio.aws.mgn.model.ApplicationHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ApplicationHealthStatus =
      software.amazon.awssdk.services.mgn.model.ApplicationHealthStatus.ERROR
  }
}
