package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{PositiveInteger, ISO8601DatetimeString}
import scala.jdk.CollectionConverters._
final case class WaveAggregatedStatus(
    healthStatus: Optional[zio.aws.mgn.model.WaveHealthStatus] =
      Optional.Absent,
    lastUpdateDateTime: Optional[ISO8601DatetimeString] = Optional.Absent,
    progressStatus: Optional[zio.aws.mgn.model.WaveProgressStatus] =
      Optional.Absent,
    replicationStartedDateTime: Optional[ISO8601DatetimeString] =
      Optional.Absent,
    totalApplications: Optional[PositiveInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.WaveAggregatedStatus = {
    import WaveAggregatedStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.WaveAggregatedStatus
      .builder()
      .optionallyWith(healthStatus.map(value => value.unwrap))(_.healthStatus)
      .optionallyWith(
        lastUpdateDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.lastUpdateDateTime)
      .optionallyWith(progressStatus.map(value => value.unwrap))(
        _.progressStatus
      )
      .optionallyWith(
        replicationStartedDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.replicationStartedDateTime)
      .optionallyWith(
        totalApplications.map(value =>
          PositiveInteger.unwrap(value): java.lang.Long
        )
      )(_.totalApplications)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.WaveAggregatedStatus.ReadOnly =
    zio.aws.mgn.model.WaveAggregatedStatus.wrap(buildAwsValue())
}
object WaveAggregatedStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.WaveAggregatedStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.WaveAggregatedStatus =
      zio.aws.mgn.model.WaveAggregatedStatus(
        healthStatus.map(value => value),
        lastUpdateDateTime.map(value => value),
        progressStatus.map(value => value),
        replicationStartedDateTime.map(value => value),
        totalApplications.map(value => value)
      )
    def healthStatus: Optional[zio.aws.mgn.model.WaveHealthStatus]
    def lastUpdateDateTime: Optional[ISO8601DatetimeString]
    def progressStatus: Optional[zio.aws.mgn.model.WaveProgressStatus]
    def replicationStartedDateTime: Optional[ISO8601DatetimeString]
    def totalApplications: Optional[PositiveInteger]
    def getHealthStatus
        : ZIO[Any, AwsError, zio.aws.mgn.model.WaveHealthStatus] =
      AwsError.unwrapOptionField("healthStatus", healthStatus)
    def getLastUpdateDateTime: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("lastUpdateDateTime", lastUpdateDateTime)
    def getProgressStatus
        : ZIO[Any, AwsError, zio.aws.mgn.model.WaveProgressStatus] =
      AwsError.unwrapOptionField("progressStatus", progressStatus)
    def getReplicationStartedDateTime
        : ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField(
        "replicationStartedDateTime",
        replicationStartedDateTime
      )
    def getTotalApplications: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("totalApplications", totalApplications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.WaveAggregatedStatus
  ) extends zio.aws.mgn.model.WaveAggregatedStatus.ReadOnly {
    override val healthStatus: Optional[zio.aws.mgn.model.WaveHealthStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.healthStatus())
        .map(value => zio.aws.mgn.model.WaveHealthStatus.wrap(value))
    override val lastUpdateDateTime: Optional[ISO8601DatetimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdateDateTime())
        .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
    override val progressStatus
        : Optional[zio.aws.mgn.model.WaveProgressStatus] = zio.aws.core.internal
      .optionalFromNullable(impl.progressStatus())
      .map(value => zio.aws.mgn.model.WaveProgressStatus.wrap(value))
    override val replicationStartedDateTime: Optional[ISO8601DatetimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationStartedDateTime())
        .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
    override val totalApplications: Optional[PositiveInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalApplications())
        .map(value => zio.aws.mgn.model.primitives.PositiveInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.WaveAggregatedStatus
  ): zio.aws.mgn.model.WaveAggregatedStatus.ReadOnly = new Wrapper(impl)
}
