package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.ClientIdempotencyToken
import scala.jdk.CollectionConverters._
final case class StartImportRequest(
    clientToken: Optional[ClientIdempotencyToken] = Optional.Absent,
    s3BucketSource: zio.aws.mgn.model.S3BucketSource
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.StartImportRequest = {
    import StartImportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.StartImportRequest
      .builder()
      .optionallyWith(
        clientToken.map(value =>
          ClientIdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .s3BucketSource(s3BucketSource.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.StartImportRequest.ReadOnly =
    zio.aws.mgn.model.StartImportRequest.wrap(buildAwsValue())
}
object StartImportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.StartImportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.StartImportRequest =
      zio.aws.mgn.model.StartImportRequest(
        clientToken.map(value => value),
        s3BucketSource.asEditable
      )
    def clientToken: Optional[ClientIdempotencyToken]
    def s3BucketSource: zio.aws.mgn.model.S3BucketSource.ReadOnly
    def getClientToken: ZIO[Any, AwsError, ClientIdempotencyToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getS3BucketSource
        : ZIO[Any, Nothing, zio.aws.mgn.model.S3BucketSource.ReadOnly] =
      ZIO.succeed(s3BucketSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.StartImportRequest
  ) extends zio.aws.mgn.model.StartImportRequest.ReadOnly {
    override val clientToken: Optional[ClientIdempotencyToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientToken())
        .map(value =>
          zio.aws.mgn.model.primitives.ClientIdempotencyToken(value)
        )
    override val s3BucketSource: zio.aws.mgn.model.S3BucketSource.ReadOnly =
      zio.aws.mgn.model.S3BucketSource.wrap(impl.s3BucketSource())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.StartImportRequest
  ): zio.aws.mgn.model.StartImportRequest.ReadOnly = new Wrapper(impl)
}
