package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mgn.model.primitives.SourceServerID
import scala.jdk.CollectionConverters._
final case class RetryDataReplicationRequest(sourceServerID: SourceServerID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.RetryDataReplicationRequest = {
    import RetryDataReplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.RetryDataReplicationRequest
      .builder()
      .sourceServerID(SourceServerID.unwrap(sourceServerID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.RetryDataReplicationRequest.ReadOnly =
    zio.aws.mgn.model.RetryDataReplicationRequest.wrap(buildAwsValue())
}
object RetryDataReplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.RetryDataReplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.RetryDataReplicationRequest =
      zio.aws.mgn.model.RetryDataReplicationRequest(sourceServerID)
    def sourceServerID: SourceServerID
    def getSourceServerID: ZIO[Any, Nothing, SourceServerID] =
      ZIO.succeed(sourceServerID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.RetryDataReplicationRequest
  ) extends zio.aws.mgn.model.RetryDataReplicationRequest.ReadOnly {
    override val sourceServerID: SourceServerID =
      zio.aws.mgn.model.primitives.SourceServerID(impl.sourceServerID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.RetryDataReplicationRequest
  ): zio.aws.mgn.model.RetryDataReplicationRequest.ReadOnly = new Wrapper(impl)
}
