package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{
  ApplicationName,
  TagValue,
  ISO8601DatetimeString,
  WaveID,
  ApplicationDescription,
  ApplicationID,
  ARN,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class Application(
    applicationAggregatedStatus: Optional[
      zio.aws.mgn.model.ApplicationAggregatedStatus
    ] = Optional.Absent,
    applicationID: Optional[ApplicationID] = Optional.Absent,
    arn: Optional[ARN] = Optional.Absent,
    creationDateTime: Optional[ISO8601DatetimeString] = Optional.Absent,
    description: Optional[ApplicationDescription] = Optional.Absent,
    isArchived: Optional[Boolean] = Optional.Absent,
    lastModifiedDateTime: Optional[ISO8601DatetimeString] = Optional.Absent,
    name: Optional[ApplicationName] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    waveID: Optional[WaveID] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.mgn.model.Application = {
    import Application.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.Application
      .builder()
      .optionallyWith(
        applicationAggregatedStatus.map(value => value.buildAwsValue())
      )(_.applicationAggregatedStatus)
      .optionallyWith(
        applicationID.map(value =>
          ApplicationID.unwrap(value): java.lang.String
        )
      )(_.applicationID)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        creationDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.creationDateTime)
      .optionallyWith(
        description.map(value =>
          ApplicationDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(isArchived.map(value => value: java.lang.Boolean))(
        _.isArchived
      )
      .optionallyWith(
        lastModifiedDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.lastModifiedDateTime)
      .optionallyWith(
        name.map(value => ApplicationName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        waveID.map(value => WaveID.unwrap(value): java.lang.String)
      )(_.waveID)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.Application.ReadOnly =
    zio.aws.mgn.model.Application.wrap(buildAwsValue())
}
object Application {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.mgn.model.Application] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.Application =
      zio.aws.mgn.model.Application(
        applicationAggregatedStatus.map(value => value.asEditable),
        applicationID.map(value => value),
        arn.map(value => value),
        creationDateTime.map(value => value),
        description.map(value => value),
        isArchived.map(value => value),
        lastModifiedDateTime.map(value => value),
        name.map(value => value),
        tags.map(value => value),
        waveID.map(value => value)
      )
    def applicationAggregatedStatus
        : Optional[zio.aws.mgn.model.ApplicationAggregatedStatus.ReadOnly]
    def applicationID: Optional[ApplicationID]
    def arn: Optional[ARN]
    def creationDateTime: Optional[ISO8601DatetimeString]
    def description: Optional[ApplicationDescription]
    def isArchived: Optional[Boolean]
    def lastModifiedDateTime: Optional[ISO8601DatetimeString]
    def name: Optional[ApplicationName]
    def tags: Optional[Map[TagKey, TagValue]]
    def waveID: Optional[WaveID]
    def getApplicationAggregatedStatus: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.ApplicationAggregatedStatus.ReadOnly
    ] = AwsError.unwrapOptionField(
      "applicationAggregatedStatus",
      applicationAggregatedStatus
    )
    def getApplicationID: ZIO[Any, AwsError, ApplicationID] =
      AwsError.unwrapOptionField("applicationID", applicationID)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getCreationDateTime: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getDescription: ZIO[Any, AwsError, ApplicationDescription] =
      AwsError.unwrapOptionField("description", description)
    def getIsArchived: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isArchived", isArchived)
    def getLastModifiedDateTime: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("lastModifiedDateTime", lastModifiedDateTime)
    def getName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("name", name)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWaveID: ZIO[Any, AwsError, WaveID] =
      AwsError.unwrapOptionField("waveID", waveID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.Application
  ) extends zio.aws.mgn.model.Application.ReadOnly {
    override val applicationAggregatedStatus
        : Optional[zio.aws.mgn.model.ApplicationAggregatedStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationAggregatedStatus())
        .map(value => zio.aws.mgn.model.ApplicationAggregatedStatus.wrap(value))
    override val applicationID: Optional[ApplicationID] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationID())
      .map(value => zio.aws.mgn.model.primitives.ApplicationID(value))
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.mgn.model.primitives.ARN(value))
    override val creationDateTime: Optional[ISO8601DatetimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationDateTime())
        .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
    override val description: Optional[ApplicationDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.mgn.model.primitives.ApplicationDescription(value)
        )
    override val isArchived: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isArchived())
      .map(value => value: Boolean)
    override val lastModifiedDateTime: Optional[ISO8601DatetimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedDateTime())
        .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
    override val name: Optional[ApplicationName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.mgn.model.primitives.ApplicationName(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mgn.model.primitives
              .TagKey(key) -> zio.aws.mgn.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val waveID: Optional[WaveID] = zio.aws.core.internal
      .optionalFromNullable(impl.waveID())
      .map(value => zio.aws.mgn.model.primitives.WaveID(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.Application
  ): zio.aws.mgn.model.Application.ReadOnly = new Wrapper(impl)
}
