package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{PositiveInteger, BoundedString}
import scala.jdk.CollectionConverters._
final case class ReplicationConfigurationReplicatedDisk(
    deviceName: Optional[BoundedString] = Optional.Absent,
    iops: Optional[PositiveInteger] = Optional.Absent,
    isBootDisk: Optional[Boolean] = Optional.Absent,
    stagingDiskType: Optional[
      zio.aws.mgn.model.ReplicationConfigurationReplicatedDiskStagingDiskType
    ] = Optional.Absent,
    throughput: Optional[PositiveInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ReplicationConfigurationReplicatedDisk = {
    import ReplicationConfigurationReplicatedDisk.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ReplicationConfigurationReplicatedDisk
      .builder()
      .optionallyWith(
        deviceName.map(value => BoundedString.unwrap(value): java.lang.String)
      )(_.deviceName)
      .optionallyWith(
        iops.map(value => PositiveInteger.unwrap(value): java.lang.Long)
      )(_.iops)
      .optionallyWith(isBootDisk.map(value => value: java.lang.Boolean))(
        _.isBootDisk
      )
      .optionallyWith(stagingDiskType.map(value => value.unwrap))(
        _.stagingDiskType
      )
      .optionallyWith(
        throughput.map(value => PositiveInteger.unwrap(value): java.lang.Long)
      )(_.throughput)
      .build()
  }
  def asReadOnly
      : zio.aws.mgn.model.ReplicationConfigurationReplicatedDisk.ReadOnly =
    zio.aws.mgn.model.ReplicationConfigurationReplicatedDisk
      .wrap(buildAwsValue())
}
object ReplicationConfigurationReplicatedDisk {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ReplicationConfigurationReplicatedDisk
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ReplicationConfigurationReplicatedDisk =
      zio.aws.mgn.model.ReplicationConfigurationReplicatedDisk(
        deviceName.map(value => value),
        iops.map(value => value),
        isBootDisk.map(value => value),
        stagingDiskType.map(value => value),
        throughput.map(value => value)
      )
    def deviceName: Optional[BoundedString]
    def iops: Optional[PositiveInteger]
    def isBootDisk: Optional[Boolean]
    def stagingDiskType: Optional[
      zio.aws.mgn.model.ReplicationConfigurationReplicatedDiskStagingDiskType
    ]
    def throughput: Optional[PositiveInteger]
    def getDeviceName: ZIO[Any, AwsError, BoundedString] =
      AwsError.unwrapOptionField("deviceName", deviceName)
    def getIops: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("iops", iops)
    def getIsBootDisk: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isBootDisk", isBootDisk)
    def getStagingDiskType: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.ReplicationConfigurationReplicatedDiskStagingDiskType
    ] = AwsError.unwrapOptionField("stagingDiskType", stagingDiskType)
    def getThroughput: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("throughput", throughput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ReplicationConfigurationReplicatedDisk
  ) extends zio.aws.mgn.model.ReplicationConfigurationReplicatedDisk.ReadOnly {
    override val deviceName: Optional[BoundedString] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceName())
      .map(value => zio.aws.mgn.model.primitives.BoundedString(value))
    override val iops: Optional[PositiveInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => zio.aws.mgn.model.primitives.PositiveInteger(value))
    override val isBootDisk: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isBootDisk())
      .map(value => value: Boolean)
    override val stagingDiskType: Optional[
      zio.aws.mgn.model.ReplicationConfigurationReplicatedDiskStagingDiskType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.stagingDiskType())
      .map(value =>
        zio.aws.mgn.model.ReplicationConfigurationReplicatedDiskStagingDiskType
          .wrap(value)
      )
    override val throughput: Optional[PositiveInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.throughput())
      .map(value => zio.aws.mgn.model.primitives.PositiveInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ReplicationConfigurationReplicatedDisk
  ): zio.aws.mgn.model.ReplicationConfigurationReplicatedDisk.ReadOnly =
    new Wrapper(impl)
}
