package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListExportsResponse(
    items: Optional[Iterable[zio.aws.mgn.model.ExportTask]] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ListExportsResponse = {
    import ListExportsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ListExportsResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ListExportsResponse.ReadOnly =
    zio.aws.mgn.model.ListExportsResponse.wrap(buildAwsValue())
}
object ListExportsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ListExportsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ListExportsResponse =
      zio.aws.mgn.model.ListExportsResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Optional[List[zio.aws.mgn.model.ExportTask.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getItems
        : ZIO[Any, AwsError, List[zio.aws.mgn.model.ExportTask.ReadOnly]] =
      AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ListExportsResponse
  ) extends zio.aws.mgn.model.ListExportsResponse.ReadOnly {
    override val items: Optional[List[zio.aws.mgn.model.ExportTask.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mgn.model.ExportTask.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.mgn.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ListExportsResponse
  ): zio.aws.mgn.model.ListExportsResponse.ReadOnly = new Wrapper(impl)
}
