package zio.aws.mgn.model
import zio.aws.mgn.model.primitives.{PaginationToken, MaxResultsType, ExportID}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListExportErrorsRequest(
    exportID: ExportID,
    maxResults: Optional[MaxResultsType] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ListExportErrorsRequest = {
    import ListExportErrorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ListExportErrorsRequest
      .builder()
      .exportID(ExportID.unwrap(exportID): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResultsType.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ListExportErrorsRequest.ReadOnly =
    zio.aws.mgn.model.ListExportErrorsRequest.wrap(buildAwsValue())
}
object ListExportErrorsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ListExportErrorsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ListExportErrorsRequest =
      zio.aws.mgn.model.ListExportErrorsRequest(
        exportID,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def exportID: ExportID
    def maxResults: Optional[MaxResultsType]
    def nextToken: Optional[PaginationToken]
    def getExportID: ZIO[Any, Nothing, ExportID] = ZIO.succeed(exportID)
    def getMaxResults: ZIO[Any, AwsError, MaxResultsType] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ListExportErrorsRequest
  ) extends zio.aws.mgn.model.ListExportErrorsRequest.ReadOnly {
    override val exportID: ExportID =
      zio.aws.mgn.model.primitives.ExportID(impl.exportID())
    override val maxResults: Optional[MaxResultsType] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.mgn.model.primitives.MaxResultsType(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.mgn.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ListExportErrorsRequest
  ): zio.aws.mgn.model.ListExportErrorsRequest.ReadOnly = new Wrapper(impl)
}
