package zio.aws.mgn.model
import scala.jdk.CollectionConverters._
sealed trait ImportStatus {
  def unwrap: software.amazon.awssdk.services.mgn.model.ImportStatus
}
object ImportStatus {
  def wrap(
      value: software.amazon.awssdk.services.mgn.model.ImportStatus
  ): zio.aws.mgn.model.ImportStatus = value match {
    case software.amazon.awssdk.services.mgn.model.ImportStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mgn.model.ImportStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.mgn.model.ImportStatus.STARTED =>
      val r = STARTED
      r
    case software.amazon.awssdk.services.mgn.model.ImportStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.mgn.model.ImportStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
  }
  case object unknownToSdkVersion extends zio.aws.mgn.model.ImportStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ImportStatus =
      software.amazon.awssdk.services.mgn.model.ImportStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.mgn.model.ImportStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ImportStatus =
      software.amazon.awssdk.services.mgn.model.ImportStatus.PENDING
  }
  case object STARTED extends zio.aws.mgn.model.ImportStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ImportStatus =
      software.amazon.awssdk.services.mgn.model.ImportStatus.STARTED
  }
  case object FAILED extends zio.aws.mgn.model.ImportStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ImportStatus =
      software.amazon.awssdk.services.mgn.model.ImportStatus.FAILED
  }
  case object SUCCEEDED extends zio.aws.mgn.model.ImportStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ImportStatus =
      software.amazon.awssdk.services.mgn.model.ImportStatus.SUCCEEDED
  }
}
