package zio.aws.mgn.model
import scala.jdk.CollectionConverters._
sealed trait ImportErrorType {
  def unwrap: software.amazon.awssdk.services.mgn.model.ImportErrorType
}
object ImportErrorType {
  def wrap(
      value: software.amazon.awssdk.services.mgn.model.ImportErrorType
  ): zio.aws.mgn.model.ImportErrorType = value match {
    case software.amazon.awssdk.services.mgn.model.ImportErrorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mgn.model.ImportErrorType.VALIDATION_ERROR =>
      val r = VALIDATION_ERROR
      r
    case software.amazon.awssdk.services.mgn.model.ImportErrorType.PROCESSING_ERROR =>
      val r = PROCESSING_ERROR
      r
  }
  case object unknownToSdkVersion extends zio.aws.mgn.model.ImportErrorType {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ImportErrorType =
      software.amazon.awssdk.services.mgn.model.ImportErrorType.UNKNOWN_TO_SDK_VERSION
  }
  case object VALIDATION_ERROR extends zio.aws.mgn.model.ImportErrorType {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ImportErrorType =
      software.amazon.awssdk.services.mgn.model.ImportErrorType.VALIDATION_ERROR
  }
  case object PROCESSING_ERROR extends zio.aws.mgn.model.ImportErrorType {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ImportErrorType =
      software.amazon.awssdk.services.mgn.model.ImportErrorType.PROCESSING_ERROR
  }
}
