package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.ISO8601DatetimeString
import scala.jdk.CollectionConverters._
final case class ExportTaskError(
    errorData: Optional[zio.aws.mgn.model.ExportErrorData] = Optional.Absent,
    errorDateTime: Optional[ISO8601DatetimeString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ExportTaskError = {
    import ExportTaskError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ExportTaskError
      .builder()
      .optionallyWith(errorData.map(value => value.buildAwsValue()))(
        _.errorData
      )
      .optionallyWith(
        errorDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.errorDateTime)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ExportTaskError.ReadOnly =
    zio.aws.mgn.model.ExportTaskError.wrap(buildAwsValue())
}
object ExportTaskError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ExportTaskError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ExportTaskError =
      zio.aws.mgn.model.ExportTaskError(
        errorData.map(value => value.asEditable),
        errorDateTime.map(value => value)
      )
    def errorData: Optional[zio.aws.mgn.model.ExportErrorData.ReadOnly]
    def errorDateTime: Optional[ISO8601DatetimeString]
    def getErrorData
        : ZIO[Any, AwsError, zio.aws.mgn.model.ExportErrorData.ReadOnly] =
      AwsError.unwrapOptionField("errorData", errorData)
    def getErrorDateTime: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("errorDateTime", errorDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ExportTaskError
  ) extends zio.aws.mgn.model.ExportTaskError.ReadOnly {
    override val errorData
        : Optional[zio.aws.mgn.model.ExportErrorData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorData())
        .map(value => zio.aws.mgn.model.ExportErrorData.wrap(value))
    override val errorDateTime: Optional[ISO8601DatetimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorDateTime())
        .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ExportTaskError
  ): zio.aws.mgn.model.ExportTaskError.ReadOnly = new Wrapper(impl)
}
