package zio.aws.mgn.model
import zio.aws.mgn.model.primitives.{
  StrictlyPositiveInteger,
  BoundedString,
  ActionName,
  DocumentVersion,
  SsmDocumentParameterName,
  ActionID,
  SourceServerID,
  OrderType
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class PutSourceServerActionRequest(
    actionID: ActionID,
    actionName: ActionName,
    active: Optional[Boolean] = Optional.Absent,
    documentIdentifier: BoundedString,
    documentVersion: Optional[DocumentVersion] = Optional.Absent,
    mustSucceedForCutover: Optional[Boolean] = Optional.Absent,
    order: OrderType,
    parameters: Optional[Map[SsmDocumentParameterName, Iterable[
      zio.aws.mgn.model.SsmParameterStoreParameter
    ]]] = Optional.Absent,
    sourceServerID: SourceServerID,
    timeoutSeconds: Optional[StrictlyPositiveInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.PutSourceServerActionRequest = {
    import PutSourceServerActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.PutSourceServerActionRequest
      .builder()
      .actionID(ActionID.unwrap(actionID): java.lang.String)
      .actionName(ActionName.unwrap(actionName): java.lang.String)
      .optionallyWith(active.map(value => value: java.lang.Boolean))(_.active)
      .documentIdentifier(
        BoundedString.unwrap(documentIdentifier): java.lang.String
      )
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(
        mustSucceedForCutover.map(value => value: java.lang.Boolean)
      )(_.mustSucceedForCutover)
      .order(OrderType.unwrap(order): Integer)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (SsmDocumentParameterName.unwrap(
                key
              ): java.lang.String) -> value.map { item =>
                item.buildAwsValue()
              }.asJavaCollection
            })
            .asJava
        )
      )(_.parameters)
      .sourceServerID(SourceServerID.unwrap(sourceServerID): java.lang.String)
      .optionallyWith(
        timeoutSeconds.map(value =>
          StrictlyPositiveInteger.unwrap(value): Integer
        )
      )(_.timeoutSeconds)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.PutSourceServerActionRequest.ReadOnly =
    zio.aws.mgn.model.PutSourceServerActionRequest.wrap(buildAwsValue())
}
object PutSourceServerActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.PutSourceServerActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.PutSourceServerActionRequest =
      zio.aws.mgn.model.PutSourceServerActionRequest(
        actionID,
        actionName,
        active.map(value => value),
        documentIdentifier,
        documentVersion.map(value => value),
        mustSucceedForCutover.map(value => value),
        order,
        parameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.map { item =>
              item.asEditable
            }
          })
        ),
        sourceServerID,
        timeoutSeconds.map(value => value)
      )
    def actionID: ActionID
    def actionName: ActionName
    def active: Optional[Boolean]
    def documentIdentifier: BoundedString
    def documentVersion: Optional[DocumentVersion]
    def mustSucceedForCutover: Optional[Boolean]
    def order: OrderType
    def parameters: Optional[Map[SsmDocumentParameterName, List[
      zio.aws.mgn.model.SsmParameterStoreParameter.ReadOnly
    ]]]
    def sourceServerID: SourceServerID
    def timeoutSeconds: Optional[StrictlyPositiveInteger]
    def getActionID: ZIO[Any, Nothing, ActionID] = ZIO.succeed(actionID)
    def getActionName: ZIO[Any, Nothing, ActionName] = ZIO.succeed(actionName)
    def getActive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("active", active)
    def getDocumentIdentifier: ZIO[Any, Nothing, BoundedString] =
      ZIO.succeed(documentIdentifier)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getMustSucceedForCutover: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("mustSucceedForCutover", mustSucceedForCutover)
    def getOrder: ZIO[Any, Nothing, OrderType] = ZIO.succeed(order)
    def getParameters: ZIO[Any, AwsError, Map[SsmDocumentParameterName, List[
      zio.aws.mgn.model.SsmParameterStoreParameter.ReadOnly
    ]]] = AwsError.unwrapOptionField("parameters", parameters)
    def getSourceServerID: ZIO[Any, Nothing, SourceServerID] =
      ZIO.succeed(sourceServerID)
    def getTimeoutSeconds: ZIO[Any, AwsError, StrictlyPositiveInteger] =
      AwsError.unwrapOptionField("timeoutSeconds", timeoutSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.PutSourceServerActionRequest
  ) extends zio.aws.mgn.model.PutSourceServerActionRequest.ReadOnly {
    override val actionID: ActionID =
      zio.aws.mgn.model.primitives.ActionID(impl.actionID())
    override val actionName: ActionName =
      zio.aws.mgn.model.primitives.ActionName(impl.actionName())
    override val active: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.active())
      .map(value => value: Boolean)
    override val documentIdentifier: BoundedString =
      zio.aws.mgn.model.primitives.BoundedString(impl.documentIdentifier())
    override val documentVersion: Optional[DocumentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentVersion())
        .map(value => zio.aws.mgn.model.primitives.DocumentVersion(value))
    override val mustSucceedForCutover: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mustSucceedForCutover())
        .map(value => value: Boolean)
    override val order: OrderType =
      zio.aws.mgn.model.primitives.OrderType(impl.order())
    override val parameters: Optional[Map[SsmDocumentParameterName, List[
      zio.aws.mgn.model.SsmParameterStoreParameter.ReadOnly
    ]]] = zio.aws.core.internal
      .optionalFromNullable(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mgn.model.primitives
              .SsmDocumentParameterName(key) -> value.asScala.map { item =>
              zio.aws.mgn.model.SsmParameterStoreParameter.wrap(item)
            }.toList
          })
          .toMap
      )
    override val sourceServerID: SourceServerID =
      zio.aws.mgn.model.primitives.SourceServerID(impl.sourceServerID())
    override val timeoutSeconds: Optional[StrictlyPositiveInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutSeconds())
        .map(value =>
          zio.aws.mgn.model.primitives.StrictlyPositiveInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.PutSourceServerActionRequest
  ): zio.aws.mgn.model.PutSourceServerActionRequest.ReadOnly = new Wrapper(impl)
}
